{CEOI 2003 - Solution for 'Square' - Tobias Thierer <ceoi@tobias-thierer.de>}
program square;
uses square_lib;
type TDirection = (left, right, up, down);
var N, L, x, y, currDist : Longint;

function getLength(x,y:Longint; dir:TDirection):Longint;
var sign, iDir:Longint;
begin
  if (dir=left) or (dir=up) then sign:=-1 else sign:=1;
  if dir=left then dec(x);
  if dir=up then dec(y);
  if (dir=left) or (dir=right) then iDir := 0 else iDir := 1;
  getLength := sign * getWeight(x,y,iDir);
end;

procedure go(dir:TDirection);
var oldX, oldY : Longint;
begin
  oldX := x; oldY := y;
  case dir of
    up:    dec(y);
    down:  inc(y);
    left:  dec(x);
    right: inc(x);
  end;
  if (x < 1) or (x > N) or (y < 1) or (y > N) then solution(-1,-1);
  currDist := currDist + getLength(oldX,oldY,dir);
  if currDist = L then solution(x,y);
end;

begin
  N := getN; L := getL; x := 1; y := 1;
  while currDist < L do if x < N then go(right) else go(down);
  repeat
    go(left);
    if currDist < L
     then while currDist < L do go(down)
     else while currDist > L do go(up);
  until false;  
end.