/*
	Problem: 	Crosswords
	Author:		Jan Kotas
	Algorithm:	simple formater
	Complexity:	n * m
*/

#include <stdio.h>

int m, n;
int count;

char mat[32][32];

void track(int i, int j)
{
	mat[i][j] = 0;
	
	if(mat[i-1][j] == '1') track(i-1, j);
	if(mat[i+1][j] == '1') track(i+1, j);
	if(mat[i][j-1] == '1') track(i, j-1);
	if(mat[i][j+1] == '1') track(i, j+1);
}

#define P(s) ((void)(spc=(printf("%*s", spc, (s)), 0)))

void sep(int i)
{
	char *a = mat[i];
	char *b = mat[i+1];	
	int j, spc = -4;
	
	for(j = 0; j <= n; j++)
	{
		spc += 5;

		if(a[j] | b[j]) P("+++++");
		else
		if(a[j+1] | b[j+1]) P("+");
	}
	
	printf("\n");
}

void empty(int i)
{
	char *b = mat[i+1];	
	int j, spc = -4;
	
	for(j = 0; j <= n; j++)
	{
		spc += 5;

		if(b[j]) P((b[j] == '1') ? "+++++" : "+");
		else
		if(b[j+1]) P("+");
	}
	
	printf("\n");
}

void full(int i)
{
	char *a = mat[i];
	char *b = mat[i+1];
	char *c = mat[i+2];
	int j, spc = -4;
	
	for(j = 0; j <= n; j++)
	{
		spc += 5;

		if(b[j])
		{
			if(b[j] == '1') P("+++++");
			else
			{
				if(((a[j] != '0') && (c[j] == '0')) ||
					(b[j-1] != '0') && (b[j+1] == '0')) 
				{
					printf("%03d +", count++);
					spc = 0;
				}
				else  P("+");
			}
		}
		else
		if(b[j+1]) P("+");
	}
	
	printf("\n");
}

void main()
{
	for(;;)
	{
		int i,j;
		
		scanf("%d %d\n", &m, &n);
		
		if(!m && !n) break;
		
		for(i = 0; i<=m+1; i++) mat[i][0] = mat[i][n+1] = 0;
		for(j = 1; j<=n; j++)   mat[0][j] = mat[m+1][j] = 0;
		
		for(i = 1; i<=m; i++)
		{
			for(j = 1; j<=n; j++)
			{
				mat[i][j] = getchar();
				getchar();
			}
		}
		
		for(i = 1; i<=m; i++)
		{
			if(mat[i][1] == '1') track(i, 1);
			if(mat[i][n] == '1') track(i, n);
		}
		
		for(j = 2; j<n; j++)
		{
			if(mat[1][j] == '1') track(1, j);
			if(mat[m][j] == '1') track(m, j);
		}
		
		count = 1;
		
		for(i = 0; i<m; i++)
		{
			sep(i);
			full(i);
			empty(i);
		}
		
		sep(m);
		
		printf("\n\n");
	}
}
