/*
	Problem: 	Network
	Author:		Jan Kotas
	Algorithm:	articulations finding (Tarjan) 
	Complexity:	n^2
*/

#include <stdio.h>
#include <string.h>

int c[128]; /* -1 - vrchol nebyl dosazen, jinak cislo vrcholu */
int lowpt[128];

int z[128]; /* zasobnik */

int e[128][128]; /* hrany z vrcholu, e[0] je pocet hran */

char t[128][128]; /* 1 - existuje hrana, 2 - prozkoumana hrana, 3 - pricka */

void addedge(int i, int j)
{
	if(t[i][j] || (i == j)) return;
	t[i][j] = 1;
	e[i][++e[i][0]] = j;
}

void main()
{
	int n, i, j, va, wa, zp, a;
	char cc;
	
	for(;;)
	{
		scanf("%d\n", &n);
		
		if(!n) break;

		for(i = 0; i < n; i++)
		{
			e[i][0] = 0;
			memset(t[i], 0, n * sizeof(t[i][0]));
		}

		for(;;)
		{
			scanf("%d%c", &i, &cc);

			if(!i) break;

			while(cc != '\n')
			{
				scanf("%d%c", &j, &cc);

				addedge(i-1, j-1);
				addedge(j-1, i-1);
			}
		}

		memset(c, -1, n * sizeof(c[0]));
		
		z[0] = 0; /* dame do zasobniku z */
		zp = 0; /* v Z je vrchol 0 */
		i = 0; /* a polozime ... */
		lowpt[0] = 0;
		c[0] = 0; /* vyjmeme jej z V a pridelime mu cislo */

		while(zp >= 0) /* je-li Z neprazdny */
		{
			va = z[zp]; /* va je vrchol na zacatku zasobniku */

			/* next few lines are dedicated to Eve... */
			while(e[va][0] && t[va][e[va][e[va][0]]] != 1) e[va][0]--;

			if(e[va][0])
			{
				wa = e[va][e[va][0]];

				if(c[wa] < 0) /* 2.a) nova hrana stromu */
				{
					z[++zp] = wa;

					lowpt[wa] = c[wa] = ++i;

					t[va][wa] = 2;
					t[wa][va] = 3;
				}
				else /* 2.b) pricka stromu */
				{
					if(lowpt[wa] < lowpt[va]) lowpt[va] = lowpt[wa];

					t[va][wa] = 3;
					t[wa][va] = 3;
				}
			}
			else /* 2.c) takova hrana neexistuje */
			{
				if(--zp >= 0)
				{
					wa = z[zp];

					if(lowpt[wa] > lowpt[va]) lowpt[wa] = lowpt[va];
				}
			}
		}
		
		a = 0;

		for(i = 1; i < n; i++) for(j = 0; j < n; j++)
			if(t[i][j] == 2 && c[i] <= lowpt[j]) 
			{
				a++;
				break;
			}

		j = 0;
		for(i = 1; i < n; i++) 
			j += (t[0][i] == 2);
		a += (j >= 2);

		printf("%d\n", a);
	}
}
