#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <assert.h>

int debug = 0;

int n, d, s;

//
//  stops and drivers for each line
//
//  internally we use numbers 0..s-1 for stops and 0..d-1 for drivers
//  and 0..n-1 for lines
//
struct line
{
  int nstops;
  int stops [50];		// list of stops
} lines [20];

struct driver
{
  int line, stop;
} drivers [30];

int conn_drivers [30][30];	// "connection matrix"
				// conn_drivers[i][j] == 1 iff drivers i,j
				// have had a chance to chat together


char buffer [1000];

int findstop (int line, int stop)	// finds a stop within the line
{
	int i;
	for (i=0; i<lines[line].nstops; i++)
	  if (lines[line].stops[i] == stop)
	    break;
	assert (i < lines[line].nstops);   // we SHOULD HAVE found it!
	return i;
}

int gcd1 (int a, int b)
{
	if (a > b)
	{
	  int tmp = a;
	  a = b;
	  b = tmp;
	}
	// so a <= b
	if (a == 0)
	  return b;
	if (a == 1)
	  return 1;
	return gcd1 (a, b%a);
}

int gcd (int a, int b)
{
	return gcd1 (abs (a), abs (b));
}

main ()
{
	FILE *fin = fopen ("gossip.in", "r"),
	     *fout = fopen ("gossip.out", "w");

	int i, j;

	for (;;)
	{
	  fgets (buffer, 999, fin);
	  sscanf (buffer, "%d%d%d", &n, &d, &s);
	  if (n == 0 && d == 0 && s == 0)
	    break;

	  // initialize the connection matrix and drivers list

	  for (i=0; i<d; i++)
	    for (j=0; j<d; j++)
	      conn_drivers [i][j] = 0;

	  for (i=0; i<d; i++)
	    drivers[i].line = drivers[i].stop = -1;

	  // input data from the file

	  for (i=0; i<n; i++)		// for each bus line
	  {
	    int stop;
	    char *p;

	    // get list of stops (first line)

	    fgets (buffer, 999, fin);	// list of stops for that line
	    lines [i].nstops = 0;
	    p = buffer;
	    while (*p != 0 && *p != '\n')
	    {
	      char *oldp = p;
	      while (isdigit (*p))
		p++;
	      if (*p == ' ' || *p == '\n')
		p++;
	      lines [i].stops [lines[i].nstops++] = atoi (oldp) - 1;
	    }

	    assert (lines[i].nstops >= 2);

	    // list of stop:driver pairs (second line)

	    fgets (buffer, 999, fin);
	    p = buffer;
	    while (*p != 0 && *p != '\n')
	    {
	      char *oldp1 = p, *oldp2;
	      while (isdigit (*p))
		p++;
	      oldp2 = ++p;
	      while (isdigit (*p))
		p++;
	      if (*p == ' ' || *p == '\n')
		p++;
	      int driver = atoi (oldp2) - 1;

	      assert (drivers[driver].line == -1);	// check

	      drivers [driver].line = i;
	      drivers [driver].stop = atoi (oldp1) - 1;
	    }
	  } // end of that bus line

	  // input is processed
	  // let's check whether each driver is defined
	  for (i=0; i<d; i++)
	    assert (drivers [i].line != -1);

	  //
	  // for each pair of drivers determine if they would meet
	  // (sometimes)
	  //

	  for (i=0; i<d; i++)
	    conn_drivers[i][i] = 1;		// sure ;-)

	  for (i=0; i<d; i++)
	    for (j=i+1; j<d; j++)
	    {
	      int l1 = drivers[i].line, l2 = drivers[j].line;

	      // drivers are at the same line at the same stop!
	      if (l1 == l2 && drivers [i].stop == drivers[j].stop)
	      {
		conn_drivers [i][j] = conn_drivers [j][i] = 1;
		continue;
	      }

	      int d1RS = -1, d2RS = -1;	// driver X stop index at his line
	      d1RS = findstop (l1, drivers[i].stop);
	      d2RS = findstop (l2, drivers[j].stop);

	      // for each common stop for the two lines ...
	      int k1, k2;
	      for (k1=0; k1<lines [l1].nstops; k1++)
		for (k2=0; k2<lines [l2].nstops; k2++)
		  if (lines [l1].stops[k1] == lines [l2].stops[k2])
		  {
		    // can they meet at THIS stop ?
		    // let X be GCD (size-of-line1, size-of-line2)
		    int X = gcd (lines[l1].nstops, lines[l2].nstops);
		    // delta1,2 - how many steps is bus 1,2 after their
		    // common stop
		    int delta1 = (d1RS-k1+lines[l1].nstops)%lines[l1].nstops;
		    int delta2 = (d2RS-k2+lines[l2].nstops)%lines[l2].nstops;
		    // they meet iff X divides delta1-delta2
		    if ((delta1-delta2)%X == 0)
		    {
		      conn_drivers [i][j] = conn_drivers[j][i] = 1;
		      goto found;
		    }
		  }
	      // ok, we tried each possible common stop
found:
	    } // we're done with this two drivers

	  // so let's compute the transitive closure of relation
	  // conn_drivers

	  int changes;
	  do
	  {
	    changes = 0;
	    for (i=0; i<d; i++)
	      for (j=i+1; j<d; j++)
		if (!conn_drivers [i][j])	// not yet connected
		{
		  int k;
		  for (k=0; k<d; k++)
		    if (conn_drivers [i][k] && conn_drivers [k][j])
		    {
		      conn_drivers [i][j] = conn_drivers [j][i] = 1;
		      changes = 1;
		      break;
		    }
		}
	  } while (changes);

	  if (debug)
	  {
	    for (i=0; i<d; i++)
	    {
	      for (j=0; j<d; j++)
		printf (conn_drivers[i][j] ? "*":".");
	      printf ("\n");
	    }
	    printf ("\n");
	  }

	  // for driver 0, is he connected to every other driver ?

	  for (i = 0; i < d; i++)
	    if (!conn_drivers [i][0])
	      break;
	  fprintf (fout, i == d ? "Yes\n" : "No\n");
	}

	fclose (fin);
	fclose (fout);
}

