// Problem E: Date, Laci, 10.11.97

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

class Date {
public:
	long year, month, day, hour, min, sec;
	long GetSecsTo();
	long GetSecsFrom();
	int IsLeap();
};

int Date::IsLeap()
{
	return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
}

long Date::GetSecsTo()
{
	static long days[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };
	long res = sec + min * 60 + hour * 3600;
	res += (day + days[month] + ((IsLeap() && month >= 2) ? 1 : 0)) * 86400;
	return res;
}

long Date::GetSecsFrom()
{
	long res = 365 * 86400L - GetSecsTo();
	if (IsLeap())
		res += 86400;
	return res;
}

	
main()
{
	FILE *fin, *fout;
	fin = fopen("mytime.in", "r");
	fout = fopen("mytime.out", "w");

	Date d1, d2;
	long c;
	char period[20];

	while (fscanf(fin, "%ld%ld%ld%ld%ld%ld", &d1.year, &d1.month, &d1.day, &d1.hour, &d1.min, &d1.sec) == 6) {
		fscanf(fin, "%ld%ld%ld%ld%ld%ld", &d2.year, &d2.month, &d2.day, &d2.hour, &d2.min, &d2.sec);
		fscanf(fin, "%ld%s", &c, period);

		
		d1.month--;
		d1.day--;
		d2.month--;
		d2.day--;

		long n;

		if (!stricmp(period, "year"))
		{
			n = d2.year - d1.year;
			if (d1.month || d1.day || d1.hour || d1.min || d1.sec)
				n--;
		}
		else if (!stricmp(period, "month"))
		{
			n = (d2.year - d1.year - 1) * 12;
			n += d2.month + 12 - d1.month;
			if (d1.day || d1.hour || d1.min || d1.sec)
				n--;
		}
		else
		{
			long d_between = 365 * (d2.year - 1 - d1.year);
			d_between += (d2.year - 1) / 4 - (d2.year - 1) / 100 + (d2.year - 1) / 400;
			d_between -= d1.year / 4 - d1.year / 100 + d1.year / 400;
		
			if (!stricmp(period, "day"))
			{
				n = d1.GetSecsFrom() / 86400 + d2.GetSecsTo() / 86400;
				n += d_between;
			}
			else if (!stricmp(period, "hour")) 
			{
				n = d1.GetSecsFrom() / 3600 + d2.GetSecsTo() / 3600;
				n += 24 * d_between;
			}
			else if (!stricmp(period, "minute"))
			{
				n = d1.GetSecsFrom() / 60 + d2.GetSecsTo() / 60;
				n += 1440 * d_between;
			}
			else
			{
				double nd = double(86400) * d_between;
				nd += d1.GetSecsFrom() + d2.GetSecsTo();
				fprintf(fout, "%.f\n", floor(nd / c));
			}
		}

		if (stricmp(period, "second")) {
			n /= c;
			fprintf(fout, "%ld\n", n);
		}
	}

	fclose(fout);
	fclose(fin);

	return 0;
}