/*
	Problem: 	Word
	Author:		Jan Kotas
	Algorithm:	find cycle
	Complexity:	O(cycle_length)
*/

#include <stdio.h>
#include <memory.h>

char s[32];

int scan_word()
{
	char *p = gets(s);

	int r = 0;
	
	for( ; *p; p++)
		r = (r << 1) | (*p != 'a');

	return r;
}

int n, mask;

int smallest(int w)
{
	int i, r = w;

	w = w | (w << n);

	for(i = 0; i < n; i++)
	{
		if((w & mask) < r) r = w & mask;
		w >>= 1;
	}

	return r;
}

int rewrite(int w, int rule)
{
	int i, r = 0;

	w = w | (w << n) | (w << (2 * n));

	for(i = 0; i < n; i++)
	{
		if(rule & (1 << (w & 15)))
			r |= 1 << i;

		w >>= 1;
	}

	return smallest(r);
}

int a[32768];

void main()
{
	int i, q, rule, w, total;

	for(;;)
	{
		if(scanf("%d\n", &n) != 1) break;

		mask = (1 << n) - 1;

		w = scan_word();

		rule = 0;

		for(i = 0; i < 8; i++)
		{
			q = scan_word();

			if(q&1)
			{
				q = (q & 8) | ((q & 6) >> 1);

				rule |= (1 << q) | (1 << (q + 4));
			}
		}

		scanf("%d", &total);

		w = smallest(w);

		memset(a, -1, sizeof(a));

		for(i = 0; i < total; i++)
		{
			if(a[w] != -1)
			{
				int cycle = i - a[w];

				i += cycle * ((total - i - 1) / cycle);
			}
			else
			{
				a[w] = i;
			}

			w = rewrite(w, rule);
		}

		for(i = n - 1; i >= 0; i--)
			printf("%c", 'a' + !!(w & (1 << i)));

		printf("\n");
	}
}
