#include <stdio.h>

/* by Michal Koucky */
/* first compute cat reachability (O(n^2))
   then we compute reachability by mouse (the same time complexity) */

/*  (d[x][y]  x --> y */
int d[128][128];
#define MOUSEDOOR 1
#define CATDOOR   2

int size;	/* number of rooms */
int mouser;	/* mouse initial room */
int catr;	/* cat initial room */
int mousecatreachable;	/* cat can catch a mouse */

int r[128];	/* reachabality of rooms */
		/* 1 - cat reachable, 2 - mouse reachable */ 

/* Size pocet mistnosti */

void init(int size)
{
	int i,j;
	for(i = size; i; i--)
	{
		for(j = size; j; j--)d[i][j]= 0;
		r[i] = 0;
	}
	mousecatreachable=0;
}

void input(int mask)
{
	int i,j;
	while( scanf("%d %d", &i, &j) != EOF && i != -1)
	{
		d[i][j]|= mask;
	}
}

void cat(int start)
{
	int i;
	r[start]=1;
	for(i = size; i; i--)
	{
		if( ( d[start][i] & CATDOOR ) &&  !r[i] )cat(i);
		
	}

}	/* cat */


void mouse(int start)
/*  we are visiting just rooms not visited by cat -> searching for cycle
    The source room don't mark as reachable; if we reach it -> cycle exist.
    If we have any door to cat-reachable room -> cat can catch mouse -> "Y" */
{
	int i;

	for(i = size; i; i--)
	{
		if( ( d[start][i] & MOUSEDOOR ) &&  !r[i] )
		{
			r[i]=2;
			mouse(i);
		}else if( (d[start][i] & MOUSEDOOR )&&(r[i]==1)) mousecatreachable=1;
		
	}
}	/* mouse */ 


int main()
{
	int N;
	scanf("%d", &N);
	while(N--)
	{
		scanf("%d %d %d", &size, &catr, &mouser);
		init(size);
		input(CATDOOR);		/* cat */
		input(MOUSEDOOR);	/* mouse */
		cat(catr);
		mouse(mouser);
		printf("%s ",(mousecatreachable || (r[mouser]==1))?"Y":"N");
		printf("%s\n", r[mouser]==2?"Y":"N");
	}
	return 0;
}	/* main */

