program sunrise ( input, output );

label 100;

var

 t: real;
 r: real;
 R : real;
 D : real;
 pi: real;
 L, theta1, theta2, beta1, beta: real;
 d: real;
 Gamma: real;
 fraction: real;

function arcsin ( op, adj: real ): real;
begin
 arcsin := arctan ( op / sqrt ( adj*adj - op * op ) );
end;

function degree ( a: real ): real;
begin
 degree := a * 180.0 / pi;
end;

function betaT ( t: real ): real;
begin
 betaT := beta1 - 2 * pi * t / 24.0 / 3600.0;
end;

begin
 r := 3950;
 R := 432000;
 D := 92900000;
 pi := 4 * arctan(1);
 L := sqrt ( D*D + R*R - r*r );
 theta1 := arctan ( R / D );
 theta2 := arctan ( L / r );
 beta1 := theta1 + theta2;
 /*
 writeln('pi = ', pi:12:2);
 writeln('L = ', L:12:2 );
 writeln('th1 =   th2 = ', degree(theta1):12:2, degree(theta2):12:2 );
 */
 while true do
 begin
  readln ( t );
  beta := betaT(t);
  d := (D * cos ( beta ) - r ) / sin ( beta );
  if ( d <= -R ) then
    Gamma := - pi / 2
  else if ( (d > -R ) and ( d < R) ) then
    Gamma := arcsin ( d , R )
  else
    Gamma := pi / 2;
  fraction := 0.5 + Gamma/pi + d * cos ( Gamma ) / pi / R;
  writeln ( fraction );

  /*
  writeln('t =   betaT =   d =   fraction = ',
         t:8:3, degree ( beta ):8:3, d:12:3, fraction:9:4);
  */

  if eof then goto 100;
 end;
100:
end.

