/* LED.p   10-30-95 */

program led ( input, output );

label 500, 700, 1000;

type

segments = (a,b,c,d,e,f,g);

var

debug: boolean;

onSegments: array[0..9] of set of segments;

sampleArray: array[0..9] of set of segments;

BOSegments: set of segments;
sequentialSegment: segments;

numberOfSamples, numberOfBurnedOutSegments: integer;

sequenceMatch: boolean;

i, j, start, length: integer;

buf: array[0..9] of char;

begin
 
 debug := false ;

 onSegments[0] := [a,b,c,d,e,f];
 onSegments[1] := [b,c];
 onSegments[2] := [a,b,d,e,g];
 onSegments[3] := [a,b,c,d,g];
 onSegments[4] := [b,c,f,g];
 onSegments[5] := [a,c,d,f,g];
 onSegments[6] := [a,c,d,e,f,g];
 onSegments[7] := [a,b,c];
 onSegments[8] := [a,b,c,d,e,f,g];
 onSegments[9] := [a,b,c,d,f,g];

 while true do
 begin
  readln ( numberOfSamples );
  
  if numberOfSamples = 0  then goto 1000;

  for i:=0 to numberOfSamples-1 do
  begin
   readln ( buf );
   
   sampleArray[i] := [];

   sequentialSegment := a;

   for j := 0 to 6 do
   begin
    if buf[j] = 'Y' then 
      sampleArray[i] := sampleArray[i] + [sequentialSegment];

    sequentialSegment := succ ( sequentialSegment );
   end;

  end; (* end reading in the samples for this data set *)




 for start := 9 downto numberOfSamples-1 do
 begin
  if debug then write ( 'start = ', start:1 );
  BOSegments := [];
  sequenceMatch := true;
  for i:= 0 to numberOfSamples-1 do
  begin

   if debug  then write ( '  i = ', i:1 );
   
   (* any BOS showing in sample?  SHOULDN'T! *)
   if BOSegments * sampleArray[i] <> [] then
   begin
     if debug then writeln ( ' some BOS showing in sample' );
     sequenceMatch := false;
     goto 500;
   end;

   (* any sample segment that isn't in good LED?  SHOULDN'T! *)
   if sampleArray[i] - onSegments[start-i] <> [] then
   begin
     if debug then
      writeln ( ' some sample segments ON that are not ON in good LED' );
     sequenceMatch := false;
     goto 500;
   end;

   (* set any additional BOSegments *)
   BOSegments := (onSegments[start-i] - sampleArray[i]) + BOSegments;

  end; (* i over numberOfSamples *)
 
  goto 700;

 500:

 end; (* of countdown starting position (start) *)

 700:

  if debug then writeln;

  if sequenceMatch then writeln( 'MATCH' )
  else writeln ( 'MISMATCH' );

 end; (* this data set *)

 1000:

end.
