(* 1996 Programming Contest Pascal Solution
 *
 * Filename: p2.p
 *
 * Authors:  Andrew Lumsdaine
 *           John Tran and Brian McCandless (translated to Pascal)
 *
 * Revision: $Id: p2.p,v 1.6 1996/10/30 23:07:19 lums Exp $
 *
 * ----------------------------------------------------------------------
 *  DESCRIPTION:
 *    See p2.c for complete description
 *
 * ----------------------------------------------------------------------
 *)

program main(input, output);

(* Constant declarations *)
const
   max_size = 100;

(* User-defined datatypes *) 
type
   set_of_criteria = array[1..max_size] of real; 

(* Goto labels *) 
label
   the_end;

(* polar to rectangle *) 
procedure polar_to_rectangular(	   r	 : real;
				   theta : real;
			       var x	 : real;
			       var y	 : real);
begin
   x := r * sin(theta);
   y := r * cos(theta);
end;

(* determinant of 2x2 *)
function det2x2(a, b, c, d : real): real;
begin
   det2x2 := (a*d - b*c);
end;

(* volume of tetrahedron *)
function volume_of_tetrahedron(px, py, pz : real;
			       qx, qy, qz : real;
			       rx, ry, rz : real) : real;
begin
   volume_of_tetrahedron := (px*det2x2(qy, qz, ry, rz) -
			     py*det2x2(qx, qz, rx, rz) + 
			     pz*det2x2(qx, qy, rx, ry)) / 6.0;
end;

(* annual volume *)
function annual_volume(	   num_criteria	 : integer;
		       var previous_year : set_of_criteria;
		       var current_year	 : set_of_criteria) : real;
var
   i, j	      : integer;
   sum, ivol  : real;
   px, py, pz : real;
   qx, qy, qz : real;
   rx, ry, rz : real;
   theta      : real;
   M_PI	      : real;
begin 
   M_PI := 4.0*arctan(1.0);
   theta := 2.0*M_PI / num_criteria;
   sum := 0;
   
   (* for each pie slice *)
   for i := 0 to num_criteria - 1 do
   begin
      (* calculate the volume of the slice *)
      (* There are three tetrahedra in the slice: abx, abc, bcd *)

      (* det a b x -> p q r *)
      polar_to_rectangular(previous_year[i + 1], theta * i, px, py);
      j := (i+1) mod num_criteria;
      polar_to_rectangular(previous_year[j + 1], theta * j, qx, qy);
      pz := 1; qz := 1; rz := 1;
      rx := 0; ry := 0; (* is pascal lovely? *)
      ivol := volume_of_tetrahedron(px, py, pz, qx, qy, qz, rx, ry, rz);
      sum := sum + abs(ivol);

      (* det a b c -> p q r *)
      polar_to_rectangular(current_year[i + 1], theta * i, rx, ry);
      rz := 0;
      ivol := volume_of_tetrahedron(px, py, pz, qx, qy, qz, rx, ry, rz);
      sum := sum + abs(ivol);

      (* det b c d -> q r p *)
      polar_to_rectangular(current_year[j + 1], theta * j, px, py);
      pz := 0;
      ivol := volume_of_tetrahedron(px, py, pz, qx, qy, qz, rx, ry, rz);
      sum := sum + abs(ivol);
   end;

   annual_volume := sum;
end; { annual_volume }


(* input year line *)
function read_year_line(    num	 : integer;
			var line : set_of_criteria): real;
var
   sum : real;
   i   : integer;
begin 
   sum := 0;
   
   for i := 1 to num do
   begin
      read(line[i]);
      sum := sum + line[i];
   end;

   readln;
   read_year_line := sum;
end;

var
   current_year	 : set_of_criteria;
   previous_year : set_of_criteria;
   i, config	 : integer;
   buffer	 : array[1..80] of char;
   cptr		 : ^char;
   num_criteria	 : integer;
   num_years	 : integer;
   year		 : integer;
   max_config	 : integer;
   vol		 : real;
   total_vol	 : real;
   max_vol	 : real;
   sum		 : real;
(* main program *) 
begin
   (* initializations *)
   max_config := 0;
   max_vol := 0;

   (* Read number of criteria and number of years *)
   readln(num_criteria, num_years);

   config := 1;

   while true do
   begin {while}
      total_vol := 0;

      (* For each configuration *)
      (* Read first year *)
      sum := read_year_line(num_criteria, previous_year);
      if sum = 0 then
	 goto the_end;

      (* For each subsequent year *)
      for year := 1 to num_years - 1 do
      begin {for}
	 sum := read_year_line(num_criteria, current_year);

	 (* Calculate annual volume using present year and prev year *)
	 vol := annual_volume(num_criteria, previous_year, current_year);

	 (* update previous year *)
	 for i := 1 to num_criteria do
	    previous_year[i] := current_year[i];

	 (* update total volume *)
	 total_vol := total_vol + vol;
      end; {for}

      (* If volume is largest, save configuration number *)
      if (total_vol > max_vol) then
      begin {if}
	 max_vol := total_vol;
	 max_config := config;
      end; {if}

      config := config + 1; (* the beauty of pascal *)
   end; {while}

   the_end:
   writeln(max_config:1, ' ', max_vol:1:2);
end.
