(* 1996 Programming Contest Pascal Solution
 *
 * Filename: p3.p
 *
 * Authors:  Andrew Lumsdaine
 *           John Tran (translated to Pascal)
 *
 * ----------------------------------------------------------------------
 *  DESCRIPTION:
 *    See p3.c for complete description
 *
 * ----------------------------------------------------------------------
 *)


program main(input, output);

(* C functions we will use *)

function acos(x	:  real): real; external C;
function atan(x	:  real): real; external C;


(* Constant declarations *)
const
   max_size = 100;

(* User-defined datatypes *) 
type
   polygon	    = array[0..max_size-1] of real;
   array_of_polygon = array[0..max_size-1] of polygon;
   
(* try to match polygon *)   
function try_match(    num_edges : integer;
		   var p1, p2	 : polygon;
		   var shift	 : integer): integer;
var
   i, j, xshift, match : integer;
label		       
   bk2, bk3; 
begin {try_match}
   match := 0;
   try_match := -1;

   for xshift := 0 to num_edges - 1 do
   begin
      match := 1;
      for i := 0 to num_edges - 1 do
      begin
	 j := (i + xshift) mod num_edges;
	 if (abs(p1[i] - p2[j]) > 1.e-3) then
	 begin {if}
	    match := 0;
	    goto bk2;
	 end; {if}
      end;
      bk2:
	  if match = 1 then
	     goto bk3;
   end;
   
   bk3:

       if match = 1 then
       begin
	  shift := xshift;
	  try_match := 0;
       end;

end; {try_match}
			     

(* polar to rectangle *) 
procedure polar_to_rectangular(    r     : real;
                                   theta : real;
                               var x     : real;
                               var y     : real);
begin
   x := r * cos(theta);
   y := r * sin(theta);
end;


(* align vertices *)
function align_vertices(    num_edges : integer;
			x, y, r	      : polygon;
			shift	      : integer;
			var angle     : real): integer;
var
   i, j, j1, match, try : integer;
   xangle		    : array[0..1] of real;
   abs1, abs2, iprod, rat   : real;
   vx1, vx2, vy1, vy2	    : real;
   theta, scale		    : real;
   My_PI, My_PI_2		    : real;
label bk1, bk2;	
begin {align_vertices}
   (* initialization *)
   My_PI := 4.0 * arctan(1.0);
   My_PI_2 := My_PI/2.0;
   i := 0;
   theta := 2 * My_PI/num_edges;

   j := shift;
   j1 := (shift + 1)  mod num_edges;

   polar_to_rectangular(r[0], My_PI_2, vx1, vy1);
   polar_to_rectangular(r[1], My_PI_2 - theta, vx2, vy2);

   vx1 := vx2 - vx1;
   vy1 := vy2 - vy1;

   vx2 := x[j1] - x[j];
   vy2 := y[j1] - y[j];

   abs1 := sqrt(vx1*vx1 + vy1*vy1);
   abs2 :=  sqrt(vx2*vx2 + vy2*vy2);
   scale := abs2/abs1;
   iprod := vx1*vx2 + vy1*vy2;

   rat := iprod/(abs1*abs2);
   xangle[0] := acos(rat);
   xangle[1] := 2. * My_PI - xangle[0];

   for try := 0 to 1 do
   begin {for}
      (* Calculate shift *)
      polar_to_rectangular(r[0] * scale, My_PI_2 + xangle[try], vx1, vy1);
      vx2 := vx1 - x[shift];
      vy2 := vy1 - y[shift];

      (* Now see if the other vertices line up *)
      match := 1;
      for i := 0 to num_edges - 1 do
      begin {for}
	 j := (shift + i) mod num_edges;
	 polar_to_rectangular(r[i] * scale, My_PI_2 + xangle[try] -
			      theta * i, vx1, vy1);
	 vx1 := vx1 - vx2;
	 vy1 := vy1 - vy2;

	 if (abs(x[j] - vx1) > 1.0E-3) or
	    (abs(y[j] - vy1) > 1.0E-3) then
	 begin {if}
	    match := 0;
	    goto bk1;
	 end {if}
      end; {for}

      bk1:
	  if match = 1 then
	  begin {if}
	     angle := xangle[try];
	     goto bk2;
	  end {if}
	  else
	     angle := 0;
   end; {for}

   bk2:
       align_vertices := match;
end; {align_vertices}




(* find the matching distance *)
function find_distance_match(	 i, num_edges : integer;
			     var d1, d2	      : array_of_polygon;
			     var shift	      : integer;
				 start	      : integer): integer;
var idx	: integer;
label bk1;
begin {find_distance_match}
   for idx := start to max_size - 1 do
      if (try_match(num_edges, d1[idx], d2[i], shift) = 0) then
	 goto bk1;
   
   bk1:
       find_distance_match := idx;
end; {find_distance_match}
   

(* input line *)
procedure read_line(num	: integer; var line : polygon);
var
   i   : integer;
begin {read_line}
   for i := 0 to num-1 do
   begin
      read(line[i]);
   end;
 
   readln;
end; {read_line}


(* input line *)
procedure read_line2(num : integer; var line1, line2 : polygon);
var
   i : integer;
begin {read_line}
   for i := 0 to num-1 do
   begin
      read(line1[i]);
      read(line2[i]);
   end;
   readln;
end; {read_line}

var 
   i, j, k	: integer;
   num_polygons	: integer;
   num_edges	: integer;
   candidate	: integer;
   r, x, y	: array_of_polygon;
   d1, d2	: array_of_polygon;
   theta, sum	: real;
   u, v, angle	: real;
   index	: array[0..max_size-1] of integer;
   matched	: integer;
   shift	: integer;
   rotate	: array[0..max_size-1] of real;
   My_PI	: real;

(* main program *) 
begin {main}
   (* initializations *)
   My_PI := 4.0 * arctan(1.0);
   
   (* Read number of polygons and number of edges of each polygon *)
   readln(num_polygons, num_edges);
   theta := 2.0 * My_PI / num_edges;

   (* Read polygons *)
   for i := 0 to num_polygons - 1 do
   begin {for}
      read_line(num_edges, r[i]);

      (* Convert (r, theta) to normalized distances *)
      (* c = sqrt(a^2+b^2-2 ab cos(theta)) *)
      sum := 0;
      for j := 0 to num_edges - 1 do
      begin
	 k := (j + 1) mod num_edges;
	 d1[i][j] :=
	 sqrt(r[i][j] * r[i][j] + r[i][k] * r[i][k]
	      - 2.0 * r[i][j] * r[i][k] * cos(theta));
	 sum := sum + d1[i][j];
      end;
      for j := 0 to num_edges - 1 do
	 d1[i][j] := d1[i][j]/sum;
   end; {for}

   (* Read polygons second round *)
   for i:= 0 to num_polygons - 1 do
   begin {for}
      read_line2(num_edges, x[i], y[i]);

      (* Convert (x, y) to normalized distances *)
      sum := 0;
      for j := 0 to num_edges - 1 do
      begin {for}
	 k := (j + 1) mod num_edges;
	 u := x[i][j] - x[i][k];
	 v := y[i][j] - y[i][k];
	 d2[i][j] := sqrt(u*u + v*v);
	 sum := sum + d2[i][j];
      end; {for}
      for j := 0 to num_edges - 1 do
	 d2[i][j] := d2[i][j]/sum;
   end; {for}

   (* Match up normalized distances *)
   for i := 0 to num_polygons - 1 do
   begin {for}
      matched := 0;
      candidate := -1;
      while matched = 0 do
      begin {while}
	 candidate :=
	 find_distance_match(i, num_edges, d1, d2, shift, candidate + 1);
	 matched := align_vertices(num_edges, x[i], y[i],
				   r[candidate], shift, angle);
      end; {while}
      rotate[i] := angle;
      index[i] := candidate;
   end; {for}
   
   for i := 0 to num_polygons - 1 do
      writeln((index[i] + 1):1, ' ', (180*rotate[i]/My_PI):1:1);
   
end. {main}
