(* 1996 Programming Contest Pascal Solution
 *
 * Filename: p4.p
 *
 * Authors:  Andrew Lumsdaine
 *           John Tran (translated to Pascal)
 *
 * ----------------------------------------------------------------------
 *  DESCRIPTION:
 *    See p4.c for complete description
 *
 * ----------------------------------------------------------------------
 *
 *)

program main(input, output);

(* Constant declarations *)
const 
   max_size = 101;

(* User-defined datatypes *)
type
   Integer_array = array[0..max_size-1] of integer;
   Char_array	 = array[0..max_size-1] of char;
   String	 = Char_array;
   Word		 = record 
		      word   : String;
		      xb, yb : integer;
		      xe, ye : integer;
		   end;	     
   Word_array	 = array[0..max_size-1] of Word;


(***** procedures and functions *****)

(* zero out the buffers *)
procedure zero_buffer(var A : String) ;
var i : integer;
begin 
   for i := 0 to max_size-1 do
      A[i] := ' ';
end; {zero_buffer}


(* compute the length of a string *)
function Length(var A : String): integer;
const
   Blank = ' ';
var
   Count : integer;
begin
   Count := max_size-1;
   while (A[Count] = Blank) do
      Count := Count - 1;
 
   Length := Count+1;
end; {Length}


(* strncmp equivalent: returns 0 if equal 1 if not *)
function String_n_compare(str1 : String;
			  p1   : integer;
			  str2 : String;
			  p2   : integer;
			  size : integer): integer;
var i, result : integer;
begin {String_n_compare}
   result := 0;

   (* not very efficient but ok, for small size *)
   for i := 0 to size-1 do 
      result := result + abs(ord(str1[i + p1]) - ord(str2[i + p2]));
      
   String_n_compare := result;
end; {String_n_compare}


(* match routine *)
procedure match(    string     : String;
		var word_array : Word_array;
		var x, y       : Integer_array);
var i, j, n, size   : integer;
begin {match}
   n := Length(string);

   (* for each letter *)
   for i:= 0 to n - 1 do 

      for j := 0 to max_size - 1 do
	 if (word_array[j].word[0] <> chr(0)) then
	 begin
	    size := Length(word_array[j].word);
	    if String_n_compare(string, i, word_array[j].word, 0, size) = 0
	       then
	    begin
	       word_array[j].xb := x[i] + 1;
	       word_array[j].xe := x[i + Length(word_array[j].word)-1] + 1;
	       word_array[j].yb := y[i] + 1;
	       word_array[j].ye := y[i + Length(word_array[j].word)-1] + 1;
	    end;
	 end;
end; {match}


(* Goto labels *)
label
   bk1, bk1_n, bk1_w, bk1_ne, bk2_ne, bk1_se, bk2_se, bk1_nw, bk2_nw;
label
   bk1_sw, bk2_sw; 

(* Variable declarations *) 
var
   i, j, k, size : integer;
   num_words	 : integer;
   word_array	 : Word_array;
   buffer	 : String;
   row, col	 : integer;
   x, y		 : Integer_array;
   puzzle	 : array[0..max_size-1] of Char_array;

(* main program *) 
begin {main}

   (* initialization steps *)
   for k := 0 to max_size-1 do (* normal we index with 0, exception here *)
   begin {for}
      word_array[k].xb := -1;
      word_array[k].xe := -1;
      word_array[k].yb := -1;
      word_array[k].ye := -1;
   end; {for}

   (* get the size of crossword puzzle *)
   readln(size);

   (* read in puzzle *);
   for k := 0 to size-1 do
      readln(puzzle[k]);

   (* input words to search for until '0' *)
   num_words := 0;
   while true do
   begin
      readln(buffer);
      if buffer = '0' then
	 goto bk1;
      word_array[num_words].word := buffer;
      num_words := num_words + 1;
   end;

   (* Get stripes: n, s, e, w, ne, nw, se, sw *)
   (* look for substrings *)
   
   
   bk1:	(* N *)
	for i := 0 to size - 1 do
	begin {for}
	   zero_buffer(buffer);
	   for j := 0 to size - 1 do
	   begin {for}
	      row := size - 1 - j;
	      col := i;
	      if (row < 0) or (row >= size)
		 or (col < 0) or (col >= size) then
		 goto bk1_n;
	      buffer[j] := puzzle[row][col];
	      x[j] := row;
	      y[j] := col;
	   end; {for}
	   bk1_n:
	   match(buffer, word_array, x, y);
	end; {for}
   
   (* E *)
   for i := 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size do
      begin {for}
	 buffer[j] := puzzle[i][j];
	 x[j] := i;
	 y[j] := j;
      end; {for}
      match(buffer, word_array, x, y);
   end; {for}

   (* W *)
   for i := 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := i;
	 col := size - 1 - j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk1_w;
	 buffer[j] := puzzle[row][col];
	    x[j] := row;
	 y[j] := col;
      end; {for}
      bk1_w:
      match(buffer, word_array, x, y);
   end;

   (* S *)
   for i := 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 buffer[j] := puzzle[j][i];
	 x[j] := j;
	 y[j] := i;
      end; {for}
      match(buffer, word_array, x, y);
   end; {for}

   (* NE *)
   for i := 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := i - j;
	 col := j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk1_ne;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk1_ne:
      match(buffer, word_array, x, y);
   end;

   for i := 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := size - 1 - j;
	 col := j + i;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk2_ne;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk2_ne:
      match(buffer, word_array, x, y);
   end;

   (* SE *)
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := i + j;
	 col := j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk1_se;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk1_se:
      match(buffer, word_array, x, y);
   end; {for}
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := j;
	 col := j + i;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk2_se;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk2_se:
      match(buffer, word_array, x, y);
   end; {for}

   (* NW *)
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := i - j;
	 col := size - 1 - j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk1_nw;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk1_nw:
      match(buffer, word_array, x, y);
   end; {for}
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := size - 1 - j;
	 col := i - j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk2_nw;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk2_nw:
      match(buffer, word_array, x, y);
   end; {for}


   (* SW *)
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := j;
	 col := i - j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk1_sw;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk1_sw:
      match(buffer, word_array, x, y);
   end; {for}
   for i:= 0 to size - 1 do
   begin {for}
      zero_buffer(buffer);
      for j := 0 to size - 1 do
      begin {for}
	 row := i + j;
	 col := size - 1 - j;
	 if (row < 0) or (row >= size) or (col < 0) or (col >= size) then
	    goto bk2_sw;
	 buffer[j] := puzzle[row][col];
	 x[j] := row;
	 y[j] := col;
      end; {for}
      bk2_sw:
      match(buffer, word_array, x, y);
   end; {for}

   for k := 0 to num_words-1 do
   begin {for}
      if word_array[k].xe <> -1 then
	 writeln(word_array[k].xb:1, ',',
		 word_array[k].yb:1, ' ',
		 word_array[k].xe:1, ',',
		 word_array[k].ye:1)
      else
	 writeln('Not found');
   end; {for}
end. {main}
