(* 1996 Programming Contest Pascal Solution
 *
 * Filename: p5.p
 *
 * Authors:  Andrew Lumsdaine
 *           John Tran (translated to Pascal)
 *
 * ----------------------------------------------------------------------
 *  DESCRIPTION:
 *    See p5.c for complete description
 *
 * ----------------------------------------------------------------------
 *
 *)

program main(input, output);

(* Constant declarations *)
const 
   MAX_SIZE = 250;
   MAX_INT  = 2147483647;

(* User-defined datatypes *)
type
   Integer_array = array[0..MAX_SIZE-1] of integer;
   String	 = array[0..MAX_SIZE-1] of char;
   

(* compute the length of a string *)
function Length(var A : String): integer;
const
   Blank = ' ';
var
   Count : integer;
begin
   Count := MAX_SIZE - 1;
   while (A[Count] = Blank) do
      Count := Count - 1;
 
   Length := Count;
end; {Length}


function myMIN(x, y :  integer): integer;
begin {myMIN}
   if (x = -1) and (y = -1) then
      myMIN := -1
   else if x = -1 then
      myMIN := y
   else if y = -1 then
      myMIN := x
   else 
   begin
      if x < y then
	 myMIN := x
      else 
	 myMIN := y;
   end;
end; {myMIN}


function isamin(    n	: integer;
		var c,d	: Integer_array): integer;
var
   i, j, min, imin : integer;
begin {isamin} 
   min := MAX_INT;
   imin := -1;

   for i := 0 to n - 1 do
   begin {for}
      j := c[i];
      if (d[j] >= 0) and (d[j] < min) then
      begin {if}
	 min := d[j];
	 imin := j;
      end; {if}
   end; {for}

   isamin := imin;
end; {isamin}


function amax(n : integer;var a : Integer_array): integer;
var i, max : integer;
begin {isamax}
   max := 0;

   for i := 0 to n - 1 do
      if (a[i] > max) then
	 max := a[i];

   amax := max;
end; {isamax}


procedure erase_v(    n : integer;
		var a : Integer_array;
		    v : integer);
var i : integer;
begin {erase}
   i := 0;
   
   while a[i] <> v do
      i := i + 1;

   while i < n - 1 do
   begin {while}
      a[i] := a[i+1];
      i := i + 1;
   end; {while}

   a[n-1] := -1;
end; {erase}


procedure read_line(var L : Integer_array);
const Blank = ' ';
var
   sum,i,j,n : integer;
   buffer    : array[0..MAX_SIZE-1] of char;
label skip_space;

begin {read_line}
   readln(buffer);
   n := Length(buffer);
   j := 0;
   i := 0;

   while i <= n do 
   begin {while}
      if buffer[i] = Blank then
      begin {if}
	 i := i + 1;
	 goto skip_space;
      end {if}
      else if buffer[i] = 'x' then
      begin {else if}
	 L[j] := -1;
	 j := j + 1;
	 i := i + 1;
	 goto skip_space;
      end {else if}
      else {else}
      begin {else}
	 sum := 0;
	 while buffer[i] <> Blank do
	 begin {while}
	    sum := sum * 10 + ( ord(buffer[i]) - 48 );
	    i := i + 1;
	 end; {while}
	 L[j] := sum;
	 j := j + 1;
      end; {else}
      skip_space:
   end; {while}
   
end; {read_line}


var
   i, j, v, w, size, csize : integer;
   C, D			   : Integer_array;
   L			   : array[0..MAX_SIZE-1] of Integer_array;
begin {main} 

   (* initialization *)
   for i := 0 to MAX_SIZE-1 do
      for j := 0 to MAX_SIZE-1 do
	 L[i][j] := 0;
   
   readln(size);

   (* for each row *)
   for i := 1 to size - 1 do
   begin
      read_line(L[i]);
      for j := 0 to i - 1 do
	 L[j][i] := L[i][j];
   end;

   (* Now do Dijkstra's algorithm *)
   for i := 0 to size - 2 do
      C[i] := i+1;

   D[0] := -1;
   for i := 1 to size - 1 do
      D[i] := L[0][i];

   csize := size - 1;
   while csize > 1 do
   begin {while}
      v := isamin(csize, C, D);
      erase_v(csize, C, v);
      for j := 0 to csize - 1 do
      begin {for}
	 w := C[j];
	 if L[v][w] <> -1 then
	    D[w] := myMIN(D[w], D[v] + L[v][w]);
      end; {for}
      csize := csize - 1;
   end; {while}

   writeln( (amax(size, D)):1);
end. {main}
