(* 1996 Programming Contest Pascal Solution
 *
 * Filename: p6.p
 *
 * Authors:  Andrew Lumsdaine
 *           John Tran (translated to Pascal)
 *
 * ----------------------------------------------------------------------
 *  DESCRIPTION:
 *    See p6.c for complete description
 *
 *)

 

program main(input, output);


(* Constant declarations *)
const 
   MAX_SIZE = 200;
   

(* User-defined datatypes *)
type
   Integer_array = array[1..MAX_SIZE] of integer;
   String	 = array[1..MAX_SIZE] of char;

(* Goto labels *)
label
   bk_pt1, bk_pt2;


(* Variable declarations *) 
var
   buffer		  : String;
   p_array		  : array[1..MAX_SIZE] of Integer_array;
   answer		  : Integer_array;
   i, j, num_integers	  : integer;
   len, digit, carry, sum : integer;



(* zero out the buffers *)
procedure zero_buffer(var A : String) ;
var i : integer;
begin 
   for i := 1 to MAX_SIZE do
      A[i] := ' ';
end; {zero_buffer}



(* compute the length of a string *)
function Length(var A : String): integer;
const
   Blank = ' ';
var
   Count : integer;
begin
   Count := MAX_SIZE;
   while (A[Count] = Blank) do
      Count := Count - 1;
 
   Length := Count;
end; {Length}



begin {main}

   (* initializations, can we trust compiler instantiate? *)
   for i:= 0 to MAX_SIZE - 1 do
      begin
	 answer[i+1] := 0;
	 for j := 0 to MAX_SIZE - 1 do
	    p_array[i][j] := 0;
      end;
   
   (* read in all the numbers LSDigit goes in 0 *)
   num_integers := 0;
   while num_integers < 100 do
   begin {while}
      zero_buffer(buffer);
      readln(buffer);
      if buffer = '0' then
	 goto bk_pt1;

      (* Reverse the digits *)
      len := Length(buffer);
      for i := 0 to len - 1 do
	 p_array[num_integers+1][i+1] := ord(buffer[len - i]) - 48;

      num_integers := num_integers + 1;
   end; {while}


   bk_pt1:    (* for each digit location *)
   carry := 0;
   for i := 0 to 197 do
   begin {for}
      (* sum all digits *) 
      sum := carry;
      for j := 0 to num_integers do
	 sum := sum + p_array[j+1][i+1];
      (* store digit and carry *)
      digit := sum mod 10;
      carry := trunc(sum/10);
      answer[i+1] := digit;
   end; {for}

   (* print answer *)
   i := 199;
   while i >= 0 do
   begin {while}
      if answer[i+1] <> 0 then
	 goto bk_pt2;
      i := i - 1;
   end; {while}

   bk_pt2:
   while i >= 0 do
   begin
      write(answer[i+1]:1);
      i := i - 1;
   end; {while}
   writeln;
end. {main}
