/* Copyright Derek Kisman (ACM ICPC ECNA 98) */


int lz[26];
int ln1[26], ln2[26];
int ll[26][100000];
int nll[26];

void get( int l, int s, int e, int *ar ) {
	int i, *ar1, *ar2;

	if( s > e ) return;
	while( lz[l] != 1 ) {
		if( lz[l] == 2 ) {
			i = s % nll[l];
			e -= s-i;
			s = i;
		}
		while( s < nll[l] && s <= e ) {
			*(ar++) = ll[l][s++];
		}
		if( s > e ) return;
		s -= nll[l];
		e -= nll[l];
		l = ln1[l];
	}
	if( s == e ) {
		if( s%2 == 0 ) {
			get( ln1[l], s/2, e/2, ar );
		} else {
			get( ln2[l], s/2, e/2, ar );
		}
		return;
	}
	ar1 = malloc( sizeof(int)*(e-s+2)/2 );
	ar2 = malloc( sizeof(int)*(e-s+2)/2 );
	get( ln1[l], (s+1)/2, e/2, ar1 );
	get( ln2[l], s/2, (e-1)/2, ar2 );
	for( i = s; i <= e; i++ ) {
		if( i%2 == 0 )
			ar[i-s] = ar1[(i-s)/2];
		else
			ar[i-s] = ar2[(i-s)/2];
	}
	free( ar1 );
	free( ar2 );
}

int used[26];
void collapse( int x ) {
	int i, j, k;
	if( lz[x] != 0 ) return;
	if( used[x] ) {
		for( i = nll[x], j = 0, k = ln1[x]; k != x; ) {
			ll[x][i++] = ll[k][j];
			if( ++j == nll[k] ) {j = 0; k = ln1[k];}
		}
		nll[x] = i;
		lz[x] = 2;
		ln1[x] = x;
		return;
	}
	used[x] = 1;
	collapse( ln1[x] );
}

int ar[300];
char buff[1000];

main() {
	int i, j, k, x, y, z;
	int n, m;
	char ch;

	scanf( " %d %d", &n, &m );
	for( i = 0; i < 26; i++ ) lz[i] = -1;
	for( i = 0; i < n; i++ ) {
		scanf( " %c", &ch );
		x = ch-'A';
		scanf( " %c", &ch );
		scanf( " %s", buff );
		if( !strcmp( buff, "zip" ) ) {
			lz[x] = 1;
			scanf( " %c", &ch );
			ln1[x] = ch-'A';
			scanf( " %c", &ch );
			ln2[x] = ch-'A';
		} else {
			lz[x] = 0;
			nll[x] = 0;
			while( *buff >= '0' && *buff <= '9' ) {
				ll[x][nll[x]++] = atoi( buff );
				scanf( " %s", buff );
			}
			ln1[x] = *buff-'A';
		}
	}
	for( i = 0; i < 26; i++ ) {
		for( j = 0; j < 26; j++ ) used[j] = 0;
		collapse( i );
	}
	for( i = 0; i < m; i++ ) {
		scanf( " %c", &ch );
		x = ch-'A';
		scanf( " %d %d", &y, &z );
		get( x, y, z, ar );
		for( j = 0; j <= z-y; j++ ) {
			if( j > 0 ) putchar( ' ' );
			printf( "%d", ar[j] );
		}
		putchar( '\n' );
	}
}
