/* Copyright Edmund Dengler (ACM ICPC ECNA 98) */


#include <stdio.h>

#define DEBUG 0

void
getit( char * buf, int len )
{
	fgets( buf, len, stdin );
	if ( feof( stdin ) )
	{
		printf( "ERROR: Input ended too early\n" );
		exit( -1 );
	}
}

int output [300];
int N, M;
int entries [26];
int entry [26][50];
int follow [26];
int zip [26][2];
int type [26];  /* 1 = normal, 2 = zip */
int cycle [26]; /* cycle len */

int
fill( unsigned int start, unsigned int end, int depth,
	 int head, unsigned int index, unsigned int increment )
{
	unsigned int i;

#if DEBUG
	printf( "%*sfill(%d,%d, %c, %d,%d)  ", depth, "",
			start, end, 'A'+head, index, increment);
	for ( i = 0; i < (end - start); i += 1 )
	{
		printf( "%d ", output [i] );
	}
	printf( "%d\n", output [end-start] );
#endif

	while ( 1 )
	{
#if DEBUG
		printf( "%*s%c, %d,%d\n", depth+1, "", 'A'+head, index, increment );
#endif

		//
		// Do we have any chance of hitting the buffer?
		//
		if ( index > end )
		{
			return;
		}
		if ( index < start )
		{
			unsigned int jumps = (start - index) / increment;
			if ( (index + jumps * increment < start) &&
				 (index + (jumps+1) * increment > end) )
			{
				return;
			}
		}

		//
		// See if we are zipping.
		//
		if ( type [head] == 2 )
		{
			fill( start, end, depth+1, zip [head][0], index, increment*2 );
			fill( start, end, depth+1, zip [head][1], index+increment, increment*2 );
			return;
		}

		//
		// Jump along as far as we can.
		//
		if ( index < start )
		{
			unsigned int jumps;

			if ( cycle [head] > 0 )
			{
				jumps = (start - index) / increment;
				jumps /= cycle [head];

				index += jumps * cycle [head] * increment;
			}

			jumps = (start - index) / increment;
			jumps /= entries [head];

			if ( jumps > 0 )
			{
				index += entries [head] * increment;
				head = follow [head];
				continue;
			}
		}

		//
		// We are close enough to the output position.
		//
		{
			unsigned int starti;
			int over;

			if ( index < start )
			{
				unsigned int jumps = (start - 1 - index) / increment;
				starti = jumps + 1;
			}
			else
			{
				starti = 0;
			}

			over = 0;
			for ( i = starti; i <= entries [head]; i += 1 )
			{
				unsigned int i2;

				if ( index + i * increment > end )
				{
					over = 1;
					break;
				}

				i2 = index + i * increment;
				output [i2-start] = entry [head][i];
			}
			if ( over )
			{
				return;
			}
			index += entries [head] * increment;
		}

		head = follow [head];
	}

}

int
main()
{
	char buf [200];
	int n;
	int i, j;

	int num;

	getit( buf, 199 );
	n = sscanf( buf, "%d %d", &N, &M );

	for ( i = 0; i < 26; i += 1 )
	{
		type [i] = 0;
		cycle [i] = 0;
	}

	for ( i = 0; i < N; i += 1 )
	{
		char head;
		char zip1;
		char zip2;

		getit( buf, 199 );

		n = sscanf( buf, "%c = zip %c %c", &head, &zip1, &zip2 );
		if ( n == 3 )
		{
			type [head-'A'] = 2;
			zip [head-'A'][0] = zip1-'A';
			zip [head-'A'][1] = zip2-'A';
		}
		else
		{
			int p, newp, val;

			n = sscanf( buf, "%c = ", &head );
			type[head-'A'] = 1;

			entries [head-'A'] = 0;
			p = 4;
			while ( 1 )
			{
				n = sscanf( buf+p, "%d %n", &val, &newp );
				if ( n != 1 )
				{
					break;
				}
				entry [head-'A'][entries [head-'A']] = val;
				entries [head-'A'] += 1;
				p += newp;
			}
			n = sscanf( buf+p, "%c", &zip1 );
			if ( (n != 1 ) || (zip1 < 'A') || (zip1 > 'Z') )
			{
				printf( "ERROR: missing ending for rule %c <%s>\n",
						head, buf+p );
			}
			follow [head-'A'] = zip1-'A';
		}
	}

	/*
	 * find cycle count.
	 */
	for ( i = 0; i < 26; i += 1 )
	{
		int i2, i2len;

		if ( type [i] == 0 )
		{
			continue;
		}
		j = 0;
		i2 = i;
		i2len = 0;
		while ( j < 26 )
		{
			if ( type [i2] == 2 )
			{
#if DEBUG
				printf( "Cycle %c: ends with zip\n", 'A'+i );
#endif
				break;
			}
			i2len += entries [i2];
			i2 = follow [i2];
			if ( i2 == i )
			{
				cycle [i] = i2len;
#if DEBUG
				printf( "Cycle %c: length of %d\n", 'A'+i, i2len );
#endif
				break;
			}
			j += 1;
		}
#if DEBUG
		if ( j >= 26 )
		{
			printf( "Cycle %c: no cycle\n", 'A'+i );
		}
		printf( "Entry %c: %d entries\n", 'A'+i, entries [i] );
#endif
	}

	/*
	 * Apply to rules.
	 */
	for ( i = 0; i < M; i += 1 )
	{
		char head;
		int start, end;
		int i2;

		getit( buf, 199 );
		n = sscanf( buf, "%c %d %d", &head, &start, &end );

		for ( i2 = 0; i2 < 300; i2 += 1 )
		{
			output [i2] = -1;
		}

		fill( start, end, 0, (int)(head-'A'), 0, 1 );

		for ( i2 = 0; i2 < (end - start); i2 += 1 )
		{
			printf( "%d ", output [i2] );
		}
		printf( "%d\n", output [end-start] );
	}

}
