/* Copyright Michael Van Biesbrouck (ACM ICPC ECNA 98) */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

struct V_t {
	char name[100];
	int nvals, cyclen;
	int iszip;
	V_t *first, *second, *next;
	char *fs, *ss, *ns;
	int vals[100];
} V[1000], *P[1000];

	int
qcmp( V_t **A, V_t **B )
{
	return strcmp((*A)->name, (*B)->name);
}

	int
bcmp( char *s, V_t **B )
{
	return strcmp(s, (*B)->name);
}

	void
ml( V_t *v, int drop, int take, int *ints, int skip )
{
	//printf( "%s %d %d %p %d\n",v->name,drop,take,ints,skip );
	if( !take ) return;
	if( v->iszip ){
		int f = drop%2;
		int s = !f;
		ml( v->first, (drop+f)/2, (take+s)/2, ints+skip*f, skip*2 );
		ml( v->second, (drop+s)/2, (take+f)/2, ints+skip*s, skip*2 );
	} else {
		if( v->cyclen ) drop %= v->cyclen;
		for( int i=drop ; i<v->nvals && take ; i++, take-- ){
			*ints = v->vals[i];
			ints+=skip;
		}
		drop -= v->nvals;
		if( drop < 0 ) drop = 0;
		if( take ) ml( v->next, drop, take, ints, skip );
	}
}

	int
main( void )
{
	int m, n, s, e, i, j;
	int ints[100000];
	char buf[1024], *p;
	V_t *v, *u;

	gets( buf );
	sscanf( buf, "%d %d", &n, &m );
	for( i=0 ; i<n ; i++ ){
		P[i] = V+i;
		scanf("%s %s", V[i].name, buf);
		scanf("%s", buf);
		p = V[i].name+strlen(V[i].name)+1;
		if( strcmp(buf,"zip") ){
			V[i].iszip = 0;
			V[i].cyclen = -1;
			V[i].nvals = 0;
			do {
				V[i].vals[V[i].nvals++] = atoi(buf);
			} while( scanf("%s",buf) && isdigit(buf[0]) );
			strcpy( p, buf );
			V[i].ns = p;
		} else {
			V[i].iszip = 1;
			V[i].cyclen = 1;
			V[i].fs = p;
			scanf("%s",p);
			p = p+strlen(p)+1;
			scanf("%s",p);
			V[i].ss = p;
		}
	}
	qsort( P, n, sizeof(V_t*), qcmp );
	for( i=0 ; i<n ; i++ ){
		if( V[i].iszip ){
			V[i].first = *((V_t**)bsearch(V[i].fs, P, n, sizeof(V_t*), bcmp));
			V[i].second = *((V_t**)bsearch(V[i].ss, P, n, sizeof(V_t*), bcmp));
		} else {
			V[i].next = *((V_t**)bsearch(V[i].ns, P, n, sizeof(V_t*), bcmp));
		}
	}
	for( i=0 ; i<n ; i++ ) if( V[i].cyclen == -1 ){
		s = 0;
		for( v=V+i ; v->cyclen == -1 ; v=v->next ){
			v->cyclen = 0;
			s += v->nvals;
		}
		for( u=V+i ; u != v ; u=u->next ) s -= u->nvals;
		for( ; v->cyclen == 0 ; v=v->next ) v->cyclen = s;
	}
	for( i=0 ; i<m ; i++ ){
		scanf( "%s %d %d", buf, &s, &e );
		e -= s - 1;
		ml( *((V_t**)bsearch(buf, P, n, sizeof(V_t*), bcmp)), s, e, ints, 1 );
		printf( "%d", ints[0] );
		for( s=1 ; s<e ; s++ ) printf(" %d",ints[s]);
		printf("\n");
	}

	return 0;
}
