/* Copyright Derek Kisman (ACM ICPC ECNA 98) */


#include <stdio.h>
#include <math.h>
#define TOL 0.00000001

typedef struct {
	double x, y;
} Point;

typedef struct {
	Point c1, c2;
} Line;

double xs, ys;
double min;
Line b[20];
int nb=0;
Point p[8];
int np;
int u[8];

Point LineIntersection( Line l1, Line l2 ) {
	Point i, d1, d2;
	double n1, n2;
	i.x = -1000000.0;
	i.y = -1000000.0;
	d1.x = l1.c2.x-l1.c1.x;
	d1.y = l1.c2.y-l1.c1.y;
	d2.x = l2.c2.x-l2.c1.x;
	d2.y = l2.c2.y-l2.c1.y;
	n2 = d1.y*d2.x-d1.x*d2.y;
	if( fabs(n2)<TOL ) return i;
	n1 = d1.x*(l2.c1.y-l1.c1.y)-d1.y*(l2.c1.x-l1.c1.x);
	i.x = n1*d2.x/n2 + l2.c1.x;
	i.y = n1*d2.y/n2 + l2.c1.y;
	return i;
}

void try( int n, double len ) {
	int i, j;
	double x;
	Line s;
	Point ip;

	if( n == np ) {
		if( len < min ) min = len;
		return;
	}
	for( i = 0; i < np; i++ ) if( !u[i] ) {
		u[i] = 1;
		b[nb].c1 = p[i];
		b[nb].c2 = p[(i+1)%np];
		while( b[nb].c2.x >= 0.0 && b[nb].c2.x <= xs &&
				b[nb].c2.y >= 0.0 && b[nb].c2.y <= ys ) {
			b[nb].c2.x += b[nb].c2.x-b[nb].c1.x;
			b[nb].c2.y += b[nb].c2.y-b[nb].c1.y;
		}
		while( b[nb].c1.x >= 0.0 && b[nb].c1.x <= xs &&
				b[nb].c1.y >= 0.0 && b[nb].c1.y <= ys ) {
			b[nb].c1.x += b[nb].c1.x-b[nb].c2.x;
			b[nb].c1.y += b[nb].c1.y-b[nb].c2.y;
		}
		s = b[nb];
		for( j = 0; j < nb; j++ ) {
			ip = LineIntersection( b[j], s );
			if( fabs(s.c1.x-s.c2.x) > TOL ) {
				if( (ip.x > s.c1.x-TOL && ip.x < s.c2.x+TOL) ||
					(ip.x < s.c1.x+TOL && ip.x > s.c2.x-TOL) ) {
					if( (ip.x > s.c1.x-TOL && ip.x < p[i].x+TOL) ||
						(ip.x < s.c1.x+TOL && ip.x > p[i].x-TOL) ) {
						s.c1.x = ip.x;
						s.c1.y = ip.y;
					} else if( (ip.x > s.c2.x-TOL && ip.x < p[(i+1)%np].x+TOL) ||
							   (ip.x < s.c2.x+TOL && ip.x > p[(i+1)%np].x-TOL) ) {
						s.c2.x = ip.x;
						s.c2.y = ip.y;
					}
				}
			} else {
				if( (ip.y > s.c1.y-TOL && ip.y < s.c2.y+TOL) ||
					(ip.y < s.c1.y+TOL && ip.y > s.c2.y-TOL) ) {
					if( (ip.y > s.c1.y-TOL && ip.y < p[i].y+TOL) ||
						(ip.y < s.c1.y+TOL && ip.y > p[i].y-TOL) ) {
						s.c1.x = ip.x;
						s.c1.y = ip.y;
					} else if( (ip.y > s.c2.y-TOL && ip.y < p[(i+1)%np].y+TOL) ||
							   (ip.y < s.c2.y+TOL && ip.y > p[(i+1)%np].y-TOL) ) {
						s.c2.x = ip.x;
						s.c2.y = ip.y;
					}
				}
			}
		}
		x = hypot( s.c2.x-s.c1.x, s.c2.y-s.c1.y );
		nb++;
		try( n+1, len+x );
		nb--;
		u[i] = 0;
	}
}

main() {
	int i, j, k, x, y, z, n, m;

	scanf( " %lf %lf", &xs, &ys );
	b[0].c1.x = 0;
	b[0].c1.y = 0;
	b[0].c2.x = 0;
	b[0].c2.y = ys;
	b[1].c1 = b[0].c2;
	b[1].c2.x = xs;
	b[1].c2.y = ys;
	b[2].c1 = b[1].c2;
	b[2].c2.x = xs;
	b[2].c2.y = 0;
	b[3].c1 = b[2].c2;
	b[3].c2 = b[0].c1;
	nb = 4;
	scanf( " %d", &np );
	for( i = 0; i < np; i++ ) scanf( " %lf %lf", &p[i].x, &p[i].y );
	min = 1000000000.0;
	try( 0, 0.0 );
	printf( "Minimum total length = %.3f\n", min );
}
