/* Copyright Edmund Dengler (ACM ICPC ECNA 98) */


#include <stdio.h>
#include <math.h>

#define DEBUG 0
#define DEBUG2 0
#define DEBUG3 0

void
getit( char * buf, int len )
{
	fgets( buf, len, stdin );
	if ( feof( stdin ) )
	{
		printf( "ERROR: Input ended too early\n" );
		exit( -1 );
	}
}

typedef struct point { double x, y; } Point;

int N, M, P;
Point coord [8];
Point corner [4];

double len [8];
double full [8][2];
double shorten [8][8][2];

double tag [256];

#if DEBUG
char pat[8];
#endif

/*
 */

double
intersect( Point * p1, Point * p2, Point * r1, Point * r2 )
{
	Point pd;
	Point rd;
	double num, den;

	pd.x = p2->x - p1->x;
	pd.y = p2->y - p1->y;
	rd.x = r2->x - r1->x;
	rd.y = r2->y - r1->y;

	den = pd.y * rd.x - pd.x * rd.y;
	num = (p1->x - r1->x) * rd.y - (p1->y - r1->y) * rd.x;

#if DEBUG
	printf( "Intersection of <%.1f,%.1f>-<%.1f,%.1f> and <%.1f,%.1f>-<%.1f,%.1f> is %.4f\n",
			p1->x, p1->y, p2->x, p2->y,
			r1->x, r1->y, r2->x, r2->y,
			num/den );
#endif

	return( num / den );
}

void
find( int idx, int cuts, int uncuts, int val )
{
	if ( (cuts == 0) && (uncuts == 0) )
	{
		double tscore;
		double score;
		int i, j, k;

#if DEBUG
		printf( "Doing %d (%02x)\n", idx, val );
#endif
		/*
		 * We need to find the best way to get here (find all layouts with
		 * one less cut, and find the cost to cut).
		 */
		score = 100001.0;
		for ( i = 0; i < P; i += 1 )
		{
			if ( (val & (1 << i)) != 0 )
			{
				/*
				 * Found a place we can make our last cut at.
				 */
#if DEBUG
				printf( "Make cut at %d (%x)->(%x)\n", i, val, val^(1<<i) );
#endif
				/*
				 * Okay here is the ugly part.
				 * We need to calculate the new cost for making a cut here.
				 * First, find out how much did we cost already.
				 * Then add in the cost for the edge itself.
				 */
				tscore = tag [val ^ (1 << i)];
				tscore += len [i];
#if DEBUG
				printf( "%.4f length\n", len [i] );
#endif

				/*
				 * Now find the cost for each end.
				 */
				for ( k = 0; k < 2; k += 1 )
				{
					int dK = k*2 - 1;
					double left = full [i][k];

					for ( j = 0; j < P; j += 1 )
					{
						if ( j == i )
						{
							continue;
						}
						if ( (val & (1 << j)) != 0 )
						{
							if ( shorten [i][j][k] > -0.000001 )
							{
								if ( shorten [i][j][k] < left )
								{
									left = shorten [i][j][k];
								}
							}
						}
					}
#if DEBUG
					printf( "%.4f left on one end\n", left );
#endif
					tscore += left;
				}

				score = ((tscore < score) ? tscore : score);
			}
		}
		if ( score >= 100001.0 )
		{
			printf( "ERROR: we did not get a proper score\n" );
		}
		tag[val] = score;

#if DEBUG
		printf( ">>> eval " );
		for ( i = 0; i < P; i += 1 )
		{
			printf( "%c", pat[i] );
		}
		printf( " as %+.4f\n", tag[val] );
#endif
		return;
	}
		
	if ( uncuts > 0 )
	{
#if DEBUG
		pat[idx] = '-';
#endif
		find( idx+1, cuts, uncuts-1, val );
	}

	if ( cuts > 0 )
	{
#if DEBUG
		pat[idx] = 'X';
#endif
		find( idx+1, cuts-1, uncuts, val | (1<<idx) );
	}
}

int
main()
{
	char buf [200];
	int n;
	int i, j, k;

	int num;
	int val;

	getit( buf, 199 );
	n = sscanf( buf, "%d %d", &N, &M );

	getit( buf, 199 );
	n = sscanf( buf, "%d", &P );

	for ( i = 0; i < P; i += 1 )
	{
		int X, Y;

		getit( buf, 199 );
		n = sscanf( buf, "%d %d", &X, &Y );

		coord[i].x = X;
		coord[i].y = Y;
	}

	corner[0].x = 0;
	corner[0].y = 0;
	corner[1].x = 0;
	corner[1].y = M;
	corner[2].x = N;
	corner[2].y = M;
	corner[3].x = N;
	corner[3].y = 0;

	for ( i = 0; i < P; i += 1 )
	{
		double dX, dY;

		dX = coord[(i+1)%P].x - coord[i].x;
		dY = coord[(i+1)%P].y - coord[i].y;

		len [i] = sqrt( dX * dX + dY * dY );
#if DEBUG
		printf( "--- <%.1f,%.1f>-<%.1f,%.1f> has length %.4f\n",
				coord[i].x, coord[i].y,
				coord[(i+1)%P].x, coord[(i+1)%P].y,
				len [i] );
#endif

		for ( k = 0; k < 2; k += 1 )
		{
			int dK = k*2 - 1;

			full [i][k] = -1.0;

			for ( j = 0; j < 4; j += 1 )
			{
				double val2;
				double val;

				val2 = intersect( &coord[i], &coord[(i+1)%P],
						&corner[j], &corner[(j+1)%4] );
				val = ((k == 0) ? (val2 - 1.0) : -val2) * len [i];

				if ( val > -0.000001 )
				{
					if ( full[i][k] < 0.0 )
					{
						full[i][k] = val;
					}
					else if ( val < full[i][k] )
					{
						full[i][k] = val;
					}
				}
			}
#if DEBUG3
			printf( "%d(%d) (len %.4f) full cut by %.4f\n",
					i, k, len [i], full [i][k] );
#endif

			for ( j = 0; j < P; j += 1 )
			{
				double val2;
				double val;

				if ( j == i )
				{
					continue;
				}
				val2 = intersect( &coord[i], &coord[(i+1)%P],
						&coord[j], &coord[(j+1)%P] );
				val = ((k == 0) ? (val2 - 1.0) : -val2) * len [i];

				if ( val > 1001.0 )
				{
					shorten [i][j][k] = 1001.0;
				}
				else if ( val > -0.00001 )
				{
					shorten [i][j][k] = val;
				}
				else
				{
					shorten[i][j][k] = -1.0;
				}

#if DEBUG3
				printf( "%d(%d) with %d (%.4f) (%.4f) is shorten by %.4f\n",
						i, k, j, len [i], val,
						shorten [i][j][k] );
#endif


			}

		}
	}

	tag [0] = 0.0;
	for ( i = 1; i <= P; i += 1 )
	{
#if DEBUG
		printf( "Finding <cuts,uncuts>=<%d,%d>\n", i, P-i );
#endif
		find( 0, i, P-i, 0 );
	}
	printf( "Minimum total length = %.3f\n", tag [(1<<P)-1] );

}
