/* Copyright Dr. John Bonomo (ACM ICPC ECNA 98) */


#include <iostream.h>
#include <math.h>

class point {
public:
  double x, y;
  point(double newx, double newy)
  { x=newx; y=newy;}
  point()
  { x = 0; y = 0;}
  print()
  { cout << "(" << x << "," << y << ")";}
};

int n, m;
point list[30];
point polyg[20];
int npoly;

double dist, mindist;

int num = 0;

bool greaterThan(double a, double b)
{
  return (a-b) > 1e-8;
}

void copyList(point newlist[], point list[], int& newp, int np)
{
  newp=np;
  for(int i=0; i<newp; i++)
    newlist[i] = list[i];
}

bool findPointa(point p1, point p2, point p3, point p4, point& pint)
{
  double a1 = p1.x;
  double b1 = p2.x-p1.x;
  double c1 = p1.y;
  double d1 = p2.y-p1.y;
  double a2 = p3.x;
  double b2 = p4.x-p3.x;
  double c2 = p3.y;
  double d2 = p4.y-p3.y;
  if (b1*d2 == b2*d1)
    return false;
  double s = (d2*(a2-a1)-b2*(c2-c1))/(b1*d2-b2*d1);
  if (greaterThan(1.0, s))
    return false;
  double t = (d1*(a2-a1)-b1*(c2-c1))/(b1*d2-b2*d1);
  if(greaterThan(0,t) || greaterThan(t,1.0))
    return false;
  pint.x = a1+b1*s;
  pint.y = c1+d1*s;
  return true;
}

bool findPointb(point p1, point p2, point p3, point p4, point& pint)
{
  double a1 = p1.x;
  double b1 = p2.x-p1.x;
  double c1 = p1.y;
  double d1 = p2.y-p1.y;
  double a2 = p3.x;
  double b2 = p4.x-p3.x;
  double c2 = p3.y;
  double d2 = p4.y-p3.y;
  if (b1*d2 == b2*d1)
    return false;
  double s = (d2*(a2-a1)-b2*(c2-c1))/(b1*d2-b2*d1);
  if (greaterThan(s,0.0))
    return false;
  double t = (d1*(a2-a1)-b1*(c2-c1))/(b1*d2-b2*d1);
  if(greaterThan(0.0,t) || greaterThan(t,1.0))
    return false;
  pint.x = a1+b1*s;
  pint.y = c1+d1*s;
  return true;
}

void findInta(point p1, point p2, point list[], int np, point& pa, int& phigh)
{
  for(int i=0; i<np; i++) {
    if (findPointa(p1, p2, list[i], list[(i+1)%np], pa)) {
      phigh = i;
      return;
    }
  }
}

void findIntb(point p1, point p2, point list[], int np, point& pb, int& plow)
{
  for(int i=0; i<np; i++) {
    if (findPointb(p1, p2, list[i], list[(i+1)%np], pb)) {
      plow = (i+1)%np;
      return;
    }
  }
}

double calcDist(int p, point list[], int& np)
{
  point pa, pb;
  int phigh, plow, newp;
  point newlist[20];

  point p1 = polyg[p];
  point p2 = polyg[(p+1) % npoly];
  findInta(p1, p2, list, np, pa, phigh);
  findIntb(p1, p2, list, np, pb, plow);
  if (plow <= phigh) {
    newp=0;
    for(int i=0; i<plow; i++) {
      newlist[newp++] = list[i];
    }
    newlist[newp++] = pb;
    newlist[newp++] = pa;
    for(int i=phigh+1; i<np; i++)
      newlist[newp++] = list[i];
  }
  else {
    newp = 0;
    newlist[newp++] = pb;
    newlist[newp++] = pa;
    for(int i=phigh+1; i<plow; i++)
      newlist[newp++] = list[i];
  }
  np = newp;
  for(int i=0; i<newp; i++)
    list[i] = newlist[i];

  double xdist = pa.x-pb.x;
  double ydist = pa.y-pb.y;
  return sqrt(xdist*xdist + ydist*ydist);
}

void doit(int a[], int start, point list[], int npoints, double dist)
{
  if (start == npoly) {
    if (dist < mindist)
      mindist = dist;
  }
  else {
    point newlist[20];
    int newpoints;
    double inc;
    for(int i=start; i<npoly;i++) {
      int temp = a[i];
      a[i] = a[start];
      a[start] = temp;
      copyList(newlist, list, newpoints, npoints);
      inc = calcDist(a[start], newlist, newpoints);
      if (dist+inc < mindist)
	doit(a, start+1, newlist, newpoints, dist+inc);
      temp = a[i];
      a[i] = a[start];
      a[start] = temp;
    }
  }
}

int main()
{
  int a[10] = {0,1,2,3,4,5,6,7,8,9};
  cin >> n >> m;
  list[0] = point(0,0);
  list[1] = point(0,m);
  list[2] = point(n,m);
  list[3] = point(n,0);
  int npoints = 4;
  cin >> npoly;
  for(int i=0; i<npoly; i++) {
    double x, y;
    cin >> x >> y;
    polyg[i] = point(x,y);
  }
  dist = 0;
  mindist = 1e50;
  doit(a, 0, list, npoints, dist);
  printf("Minimum total length = %.3f\n", mindist);
}
