/*
 * Solution to "Street Directions"
 *
 * Author: Howard Cheng
 * Date: Nov 2, 1998
 *
 * Comment: look for bridges (bicomponents with one edge), these must be 
 *          two-way streets.  All other streets are one-way.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define MAX_N 1000
#define MAX_DEG 4
#define MAX_M MAX_DEG*MAX_N/2

int n, m;
int deg[MAX_N+1];
int adj[MAX_N+1][MAX_DEG];
int dfs[MAX_N+1];
int back[MAX_N+1];
int n_stack, dfn;
int v_stack[MAX_M];
int w_stack[MAX_M];

#ifdef CHECK
int DFS(int src, int prev, int visited[MAX_N+1])
{
  int i, w;

  if (visited[src]) {
    return 0;
  }
  if (1 <= src && src <= prev) {
    return 1;
  }
  visited[src] = 1;
  for (i = 0; i < deg[src]; i++) {
    w = adj[src][i];
    if (DFS(w, prev, visited)) {
      return 1;
    }
  }
  return 0;
}

int check_reachability(void)
{
  int visited[MAX_N+1];
  int i, j;
 
  for (i = 1; i <= n; i++) {
    visited[i] = 0;
  }
  DFS(1, 0, visited);
  for (i = 1; i <= n; i++) {
    if (!visited[i]) {
      return 0;
    }
  }
  for (i = 2; i <= n; i++) {
    for (j = 1; j <= n; j++) {
      visited[j] = 0;
    }
    if (!DFS(i, i-1, visited)) {
      return 0;
    }
  }
  return 1;
}
#endif

int min(int x, int y)
{
  return (x < y) ? x : y;
}

int read_case(void)
{
  int i, u, v, t;

  t = scanf("%d %d", &n, &m);
  assert(t == 2);
  if (n == 0 && m == 0) {
    return 0;
  }
  assert(2 <= n && n <= MAX_N);
  assert(1 <= m && m <= MAX_M);    

  for (i = 1; i <= n; i++) {
    deg[i] = 0;
  }
  for (i = 0; i < m; i++) {
    t = scanf("%d %d", &u, &v);
    assert(t == 2);
    assert(1 <= u && u <= n);
    assert(1 <= v && v <= n);
    assert(u != v);
#ifdef CHECK
    for (t = 0; t < deg[u]; t++) {
      assert(adj[u][t] != v);
    }
    for (t = 0; t < deg[v]; t++) {
      assert(adj[v][t] != u);
    }
#endif
    adj[u][deg[u]++] = v;
    adj[v][deg[v]++] = u;
    assert(0 <= deg[u] && deg[u] <= 4);
    assert(0 <= deg[v] && deg[v] <= 4);
  }

#ifdef CHECK
  assert(check_reachability());
#endif
  return 1;
}

void bicomp(int v, int pred)
{
  int i, w, count;

  dfn++;
  dfs[v] = back[v] = dfn;
  for (i = 0; i < deg[v]; i++) {
    w = adj[v][i];
    if (dfs[w] < dfs[v] && w != pred) {
      /* back edge or unexamined forward edge */
      v_stack[n_stack] = v;
      w_stack[n_stack] = w;
      n_stack++;
    }
    if (!dfs[w]) {
      bicomp(w, v);
      /* back up from recursion */
      if (back[w] >= dfs[v]) {
	/* new bicomponent */
	count = 0;
	while (v_stack[n_stack-1] != v || w_stack[n_stack-1] != w) {
	  assert(n_stack > 0);
	  printf("%d %d\n", v_stack[n_stack-1], w_stack[n_stack-1]);
	  n_stack--;
	  count++;
	}
	printf("%d %d\n", v_stack[n_stack-1], w_stack[n_stack-1]);
	if (count == 0) {
	  /* we have a bicomponent containing only one edge */
	  printf("%d %d\n", w_stack[n_stack-1], v_stack[n_stack-1]);
	}
	n_stack--;
      } else {
	back[v] = min(back[v], back[w]);
      }
    } else {
      /* w has been examined already */
      back[v] = min(back[v], dfs[w]);
    }
  }
}

void do_case(void)
{
  int i;

  n_stack = 0;
  dfn = 0;
  for (i = 1; i <= n; i++) {
    dfs[i] = 0;
  }
  bicomp(1, -1);
}

int main(void)
{
  int case_no = 1;
  while (read_case()) {
    printf("%d\n\n", case_no++);
    do_case();
    printf("#\n");
  }
  return 0;
}
