/* Copyright Edmund Dengler (ACM ICPC ECNA 98) */


#include <stdio.h>

#define DEBUG 0

void
getit( char * buf, int len, FILE * file )
{
	fgets( buf, len, file );
	if ( feof( stdin ) )
	{
		printf( "ERROR: Input ended too early\n" );
		exit( -1 );
	}
}

int
main()
{
	/*
	 * processor A-Z
	 * instructions 1-100
	 */

	char buf [200];
	int n;
	int i, j, k, len;
	char * s;

	int num;

	int size [26]; /* number of instructions */
	int ind [2][2][26][26]; /* number outstanding (blk,dir,src,dst) */
	int cnt [2][26]; /* number cumulative (blk,src,dst) */
	int I [26]; /* instruction ptr */
	int Iaddr [26][150]; /* instruction address */
	char Idata [20000]; /* instructions */
	int exist [26];
	int done [26];
	int blocked [26];
	int idx;

	int t;
	int progress;

	for ( i = 0; i < 26; i += 1 )
	{
		done[i] = 0;
		blocked[i] = 0;
		exist[i] = 0;

		I[i] = 0;
		cnt[0][i] = 0; /* blocked ops */
		cnt[0][i] = 0; /* non-blocked ops */
		for ( j = 0; j < 26; j += 1 )
		{
			ind[0][0][i][j] = 0; /* blocked sends */
			ind[0][1][i][j] = 0; /* blocked receives */
			ind[1][0][i][j] = 0; /* non-blocked sends */
			ind[1][1][i][j] = 0; /* non-blocked receives */
		}
	}
	idx = 0;

	getit( buf, 199, stdin );
	n = sscanf( buf, "%d", &num );

	for ( i = 0; i < num; i += 1 )
	{
		char proc;
		int p;
		int tsize;

		getit( buf, 199, stdin );
		n = sscanf( buf, "%c %d", &proc, &tsize );

		p = proc - 'A';
		size[p] = tsize;
		exist[p] = 1;

		for ( j = 0; j < tsize; j += 1 )
		{
			getit( buf, 199, stdin );

			Iaddr[p][j] = idx;

			len = strlen( buf );
			for ( k = 0; k < len; k += 2 )
			{
				if ( (k == 0) && (buf[k] != 'B') && (buf[k] != 'N') )
				{
					printf( "ERROR: proc %c line %d: not B or N\n",
							'A'+p, j );
				}
				if ( (k == 2) && (buf[k] != 'S') && (buf[k] != 'R') )
				{
					printf( "ERROR: proc %c line %d: not S or R\n",
							'A'+p, j );
				}
				if ( (buf[k] < 'A') || (buf[k] > 'Z') )
				{
					printf( "ERROR: proc %c line %d: invalid letter\n",
							'A'+p, j );
				}
				Idata[idx++] = buf[k];
			}
			Idata[idx++] = '\0';
		}
	}

	t = 0;
	progress = 1;
	while ( progress == 1 )
	{
		t += 1;
		progress = 0;

#if DEBUG
		printf( "time t=%d\n", t );
		fflush( stdout );
#endif

		for ( i = 0; i < 26; i += 1 )
		{
			int blk;
			int dir;

			if ( ! exist[i] )									{ continue; }
#if DEBUG
			printf( "processor %c\n", 'A'+i );
#endif
			if ( done[i] > 0 )									{ continue; }
			if ( blocked[i] == 1 )								{ continue; }
			if ( I[i] >= size[i] )								{ continue; }

			s = &Idata[ Iaddr[i][ I[i] ] ];

			blk = ((*s++ == 'B') ? 0 : 1 );
			dir = ((*s++ == 'S') ? 0 : 1 );

			for ( k = 2; *s != '\0'; k += 1 )
			{
				j = (*s++) - 'A';
#if DEBUG
				printf( "%c%c %c-%c   ",
						((blk == 0) ? 'B' : 'N'),
						((dir == 0) ? 'S' : 'R'),
						'A'+i, 'A'+j );
#endif

				if ( ind[1][1-dir][j][i] > 0 ) /* check non-blocking first */
				{
#if DEBUG
					printf( "(matches non-blocking) " );
#endif
					ind[1][1-dir][j][i] -= 1;
					cnt[1][j] -= 1;
				}
				else if ( ind[0][1-dir][j][i] > 0 ) /* then check blocking */
				{
#if DEBUG
					printf( "(matches blocking) " );
#endif
					ind[0][1-dir][j][i] -= 1;
					cnt[0][j] -= 1;
				}
				else if ( blk == 0) /* otherwise add op to awaiting */
				{
#if DEBUG
					if ( DEBUG ) { printf( "(blocked) " ); }
#endif
					ind[0][dir][i][j] += 1;
					cnt[0][i] += 1;
					blocked[i] = 1;
				}
				else
				{
#if DEBUG
					if ( DEBUG ) { printf( "(not blocked) " ); }
#endif
					ind[1][dir][i][j] += 1;
					cnt[1][i] += 1;
				}
#if DEBUG
				printf( "\n" );
#endif
				progress = 1;
			}
		}

		for ( i = 0; i < 26; i += 1 )
		{
			if ( ! exist[i] )									{ continue; }
			if ( done[i] > 0 )									{ continue; }

			if ( (blocked[i] == 1) && (cnt[0][i] == 0) )
			{
				blocked[i] = 0;
				progress = 1;
			}
		}

		for ( i = 0; i < 26; i += 1 )
		{
			if ( ! exist[i] )									{ continue; }
			if ( done[i] > 0 )									{ continue; }
			if ( blocked[i] == 1 )								{ continue; }

			if ( I[i] < size[i] )
			{
				I[i] += 1;
				progress = 1;
			}

			if ( (I[i] >= size[i]) && (cnt[1][i] == 0) )
			{
				done[i] = t;
#if DEBUG
				printf( "%c is done\n", 'A'+i );
#endif
			}
		}

#if DEBUG
		for ( i = 0; i < 26; i += 1 )
		{
			if ( ! exist[i] )									{ continue; }

			printf( ">> %c %d/%d   B=%d N=%d d=%d b=%d\n",
					'A'+i, I[i], size[i],
					cnt[0][i], cnt[1][i], done[i], blocked[i] );

			for ( j = 0; j < 26; j += 1 )
			{
				int blk;
				int dir;

				for ( blk = 0; blk < 2; blk += 1 )
				{
					for ( dir = 0; dir < 2; dir += 1 )
					{
						if ( ind[blk][dir][i][j] > 0 )
						{
							printf( ">> -- %c%c %c-%c %d\n",
									((blk == 0) ? 'B' : 'N'),
									((dir == 0) ? 'S' : 'R'),
									'A'+i, 'A'+j, ind[blk][dir][i][j] );
						}
					}
				}
			}
		}
#endif
	}

	for ( i = 0; i < 26; i += 1 )
	{
		if ( ! exist[i] )										{ continue; }

		if ( done[i] > 0 )
		{
			printf( "%c finishes at t=%d\n", 'A'+i, done[i] );
		}
		else
		{
			int and = 0;

			printf( "%c never finishes because of", 'A'+i );
			for ( j = 0; j < 26; j += 1 )
			{
				int sum;
				int blk;
				int dir;

				sum = 0;
				for ( blk = 0; blk < 2; blk += 1 )
				{
					for ( dir = 0; dir < 2; dir += 1 )
					{
						sum += ind[blk][dir][i][j];
					}
				}
				if ( sum > 0 )
				{
					printf( "%s %c", ((and == 1) ? " and" : ""), 'A'+j );
					and = 1;
				}
			}
			printf( "\n" );
		}
	}

	return( 0 );
}
