#!/xhbin/perl5 -sw
# Copyright Michael Van Biesbrouck (ACM ICPC ECNA 98)


$debug=0 if ! defined $debug;
@m = ();
@I = ();
@BR = ();
@NR = ();
@BS = ();
@NS = ();
@F = ();
%M=();

$_=<>;

while( <> ){
	($name,$n)=/(\w+)\s+(\d+)/;
	push @m, $name;
	push @BR, [];
	push @BS, [];
	push @NR, [];
	push @NS, [];
	my( @i ) = ();
	while( $n-- ){
		$_ = <>;
		chomp;
		$i[$n] = $_;
	}
	push @I, \@i;
}

$t = 1;
do {
	print "t=$t\n" if $debug;
	$did = 0;
	for($i=0;$i<=$#m;$i++){
		if( ! @{$BR[$i]} && ! @{$BS[$i]} ){
			$_ = pop @{$I[$i]};
			if( !defined $_ ){
				print "$m[$i] ran out of instructions\n" if $debug;
				if( ! @{$NR[$i]} && ! @{$NS[$i]} && !defined $F[$i] ){
					$F[$i] = $t-1;
					$did = 1;
					print "(finished at $F[$i])\n" if $debug;
				}
				next;
			}
			$did = 1;
			($b,$s,$_) = /(.) (.) (.*)/;
			#print "$m[$i] got $b/$s/$_\n" if $debug;
			for(split){
				print "$m[$i] got $b/$s/$_\n" if $debug;
				$M{"${s}_$m[$i]$_"}++;
				if( $s eq "S" ){
					if( $b eq "B" ){
						push @{$BS[$i]}, $_;
					} else {
						push @{$NS[$i]}, $_;
					}
				} else {
					if( $b eq "B" ){
						push @{$BR[$i]}, $_;
					} else {
						push @{$NR[$i]}, $_;
					}
				}
			}
		} else {
			print "$m[$i] waiting for ", join(" ","R", @{$BR[$i]},"S", @{$BS[$i]} ), "\n" if $debug;
		}
	}
	for($i=0;$i<=$#m;$i++){
		my( @L ) = ();
		for(@{$NS[$i]}){
			if( $M{"R_$_$m[$i]"} ){
				$M{"R_$_$m[$i]"}--;
				$did=1;
				print "$m[$i] NS to $_ done\n" if $debug;
			} else {
				push @L, $_;
			}
		}
		$NS[$i] = [@L];
		@L = ();
		for(@{$NR[$i]}){
			if( $M{"S_$_$m[$i]"} ){
				$M{"S_$_$m[$i]"}--;
				$did=1;
				print "$m[$i] NR from $_ done\n" if $debug;
			} else {
				push @L, $_;
			}
		}
		$NR[$i] = [@L];
		@L = ();
		for(@{$BS[$i]}){
			if( $M{"R_$_$m[$i]"} ){
				$M{"R_$_$m[$i]"}--;
				$did=1;
				print "$m[$i] BS to $_ done\n" if $debug;
			} else {
				push @L, $_;
			}
		}
		$BS[$i] = [@L];
		@L = ();
		for(@{$BR[$i]}){
			if( $M{"S_$_$m[$i]"} ){
				$M{"S_$_$m[$i]"}--;
				$did=1;
				print "$m[$i] BR from $_ done\n" if $debug;
			} else {
				push @L, $_;
			}
		}
		$BR[$i] = \@L;
	}
	$t++;
} while( $did );


for $i (sort {$m[$a] cmp $m[$b]} (0 .. $#m)){
	print "$m[$i] ";
	if( defined $F[$i] ){
		print "finishes at t=$F[$i]\n";
	} else {
		print "never finishes because of ";
		%H = ();
		for((@{$BR[$i]},@{$BS[$i]},@{$NR[$i]},@{$NS[$i]})){ $H{$_} = 1; }
		#print join(" and ",grep {exists $H{$_}} @m), "\n";
		print join(" and ",(sort (keys %H))), "\n";
	}
}

0;
