#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <string.h>

const int A_10 = 55;
const int ZERO = 48;
const int ASIZE = 8;
const int WSIZE = 7;
const int SIZE_1 = 6;

long int power (int, int);
long int convert_to_10 (int, char *);
int      convert_to_base (int, long int, char *);

long int power (int base, int raise)
 {
  long int prod = 1;
  int      i;

  for (i = 0; i < raise; i++)
   prod *= base;

  return prod;
 }

long int convert_to_10 (int base, char * cnum)
 {
  int      len = strlen (cnum) - 1;
  int      i;
  int      raise = 0;
  int      num;
  long int base10 = 0;

  for (i = len; i >= 0 && cnum[i] != ' '; i--)
   {
    if (cnum[i] >= '0' && cnum[i] <= '9')
     num = cnum[i] - ZERO;
    else
     num = cnum[i] - A_10;

    base10 += num * power (base, raise);

    raise++;
   }

  return base10;
 }

int convert_to_base (int base, long int number, char * cnum)
 {
  int  pos = SIZE_1;
  int  valid = 1;
  int  remain;
  char chremain;

  strcpy (cnum, "       ");

  while (number > 0 && valid)
   {
    remain = number % base;
    number /= base;

    if (remain < 10)
     chremain = remain + ZERO;
    else
     chremain = remain + A_10;

    if (pos >= 0)
     {
      cnum[pos] = chremain;
      pos--;
     }
    else
     valid = 0;
   }

  return valid;
 }

void main ()
 {
  char     old_cnum[ASIZE];
  char     new_cnum[ASIZE];
  int      base_from;
  int      base_to;
  int      valid;
  long int number;
  fstream  in_file;
  ofstream out_file;

  in_file.open ("base.in", ios::in);
  out_file.open ("base.out");

  in_file >> ws >> old_cnum >> base_from >> base_to;

  while (!in_file.eof ())
   {
    number = convert_to_10 (base_from, old_cnum);
    valid = convert_to_base (base_to, number, new_cnum);

    if (valid)
     out_file << setw (WSIZE) << new_cnum << endl;
    else
     out_file << setw (WSIZE) << "ERROR" << endl;

    in_file >> ws >> old_cnum >> base_from >> base_to;
   }

  in_file.close ();
  out_file.close ();
 }
