/*---------------------------------------------------------------------------*\
  cubes.cpp - Perfect Cubes - Turbo C++ 3.0
  1995 ACM Mid-Central Regional Programming Contest
  Judge's Solution by Ron Pacheco <pacheco@harding.edu>
  Harding University Computer Science Department
\*---------------------------------------------------------------------------*/

#include <fstream.h>

struct cube {
   long a, b, c, d;
   cube* next;
};

cube* list = NULL;

void addcube( long a, long b, long c, long d ) {

   cube* n = new cube;
   n->a = a;
   n->b = b;
   n->c = c;
   n->d = d;
   if (list == NULL || n->a < list->a) {
      n->next = list;
      list = n;
   }
   else {
      cube* p = list;
      while (p->next != NULL && n->a >= p->next->a) p = p->next;
      n->next = p->next;
      p->next = n;
   }
}

void printcubes( void ) {

   ofstream ofs = "cubes.out";
   cube* p = list;
   while (p != NULL) {
      if (p->a > 200) return;
      ofs << "Cube = " << p->a << ", Triple = (";
      ofs << p->b << ',' << p->c << ',' << p->d << ')' << endl;
      p = p->next;
   }
}

void main() {

   long max = 100, max3 = max * max * max;
   long a, b, c, d, a3, b3, c3, d3, t3;
   b = 2;
   b3 = b * b * b;
   while (b3 + b3 + b3 <= max3) {
      c = b;
      c3 = c * c * c;
      while (b3 + c3 + c3 <= max3) {
         d = c;
         d3 = d * d * d;
         while (b3 + c3 + d3 <= max3) {
            t3 = b3 + c3 + d3;
            for (a = 2; a <= 100; a++) {
               a3 = a * a * a;
               if (a3 == t3) addcube( a, b, c, d );
            }
            d++;
            d3 = d * d * d;
         }
         c++;
         c3 = c * c * c;
      }
      b++;
      b3 = b * b * b;
   }
   printcubes();
}
