/*---------------------------------------------------------------------------*\
  dna.cpp - DNA Translation - Turbo C++ 3.0
  1995 ACM Mid-Central Regional Programming Contest
  Judge's Solution by Ron Pacheco <pacheco@harding.edu>
  Harding University Computer Science Department
\*---------------------------------------------------------------------------*/

#include <fstream.h>
#include <string.h>

ifstream ifs = "dna.in";
ofstream ofs = "dna.out";

void codon2protein( char* codon ) {
   switch (codon[0]) {
    case 'T':
      switch (codon[1]) {
       case 'T':
         switch (codon[2]) {
          case 'T': ofs << "Phe"; break;
          case 'C': ofs << "Phe"; break;
          case 'A': ofs << "Leu"; break;
          case 'G': ofs << "Leu";
         }
         break;
       case 'C':
         ofs << "Ser"; break;
       case 'A':
         switch (codon[2]) {
          case 'T': ofs << "Tyr"; break;
          case 'C': ofs << "Tyr";
         }
         break;
       case 'G':
         switch (codon[2]) {
          case 'T': ofs << "Cys"; break;
          case 'C': ofs << "Cys"; break;
          case 'G': ofs << "Trp";
         }
      }
      break;
    case 'C':
      switch (codon[1]) {
       case 'T':
         ofs << "Leu"; break;
       case 'C':
         ofs << "Pro"; break;
       case 'A':
         switch (codon[2]) {
          case 'T': ofs << "His"; break;
          case 'C': ofs << "His"; break;
          case 'A': ofs << "Gln"; break;
          case 'G': ofs << "Gln";
         }
         break;
       case 'G':
         ofs << "Arg"; break;
      }
      break;
    case 'A':
      switch (codon[1]) {
       case 'T':
         switch (codon[2]) {
          case 'G': ofs << "Met"; break;
          default: ofs << "Ile";
         }
         break;
       case 'C':
         ofs << "Thr"; break;
       case 'A':
         switch (codon[2]) {
          case 'T': ofs << "Asn"; break;
          case 'C': ofs << "Asn"; break;
          case 'A': ofs << "Lys"; break;
          case 'G': ofs << "Lys";
         }
         break;
       case 'G':
         switch (codon[2]) {
          case 'T': ofs << "Ser"; break;
          case 'C': ofs << "Ser"; break;
          case 'A': ofs << "Arg"; break;
          case 'G': ofs << "Arg";
         }
      }
      break;
    case 'G':
      switch (codon[1]) {
       case 'T':
         ofs << "Val"; break;
       case 'C':
         ofs << "Ala"; break;
       case 'A':
         switch (codon[2]) {
          case 'T': ofs << "Asp"; break;
          case 'C': ofs << "Asp"; break;
          case 'A': ofs << "Glu"; break;
          case 'G': ofs << "Glu";
         }
         break;
       case 'G':
         ofs << "Gly"; break;
      }
   }
}

void transcodes( char* dna, int codes ) {

   for (int i = 0; i < codes; i++) {
      char codon[4];
      strncpy( codon, dna + 3 * i, 3 );
      codon[3] = '\0';
      codon2protein( codon );
      if (i < codes - 1) ofs << '-';
   };
   ofs << endl;
}

char* terminator( char* start ) {

   for (int i = 6; i < strlen( start ) - 2; i += 3)
      if (start[i] == 'T')
         switch (start[i+1]) {
          case 'A':
            if (start[i+2] == 'A' || start[i+2] == 'G') return start + i;
            break;
          case 'G':
            if (start[i+2] == 'A') return start + i;
         }
   return NULL;
}

int translate( char* dna ) {

   char* start = strstr( dna, "ATG" );
   while (start != NULL) {
      char* end = terminator( start );
      if (end != NULL) {
         transcodes( start + 3, (end - start - 3) / 3 );
//       return 1;
         return 0;
      }
      else
         start = strstr( start + 1, "ATG" );
   }
   return 0;
}

void complement( char* dna ) {

   for (int i = 0; i < strlen( dna ); i++)
      switch (dna[i]) {
       case 'A': dna[i] = 'T'; break;
       case 'C': dna[i] = 'G'; break;
       case 'G': dna[i] = 'C'; break;
       case 'T': dna[i] = 'A';
      }
}

void main() {

   char dna[256];
   ifs >> dna;
   while (*dna != '*') {
      ofs << "===============================================" << endl;
      if (!translate( dna ) && !translate( strrev( dna ) )) {
         complement( dna );
         if (!translate( dna ) && !translate( strrev( dna ) ))
            ofs << "*** No translatable DNA found ***" << endl;
      }
      ifs >> dna;
   }
}
