/*
  Solution to Import
  
  Dr. Eric Shade
  Computer Science Department
  Southwest Missouri State University
  10/1/95
*/  

#include <stdio.h>
#include <string.h>
#include <math.h>

#define INPUT_FILE_NAME  "import.in"
#define OUTPUT_FILE_NAME "import.out"

#define N         27
#define INFINITY 100
#define EARTH     26

int distance[N][N];
double value[N];

FILE *infile, *outfile;


void Floyd_Warshall (void)
{
  register int i, j, k;

  for (k = 0; k < N; ++k)
    for (i = 0; i < N; ++i)
      for (j = 0; j < N; ++j)
        {
          int distance_ikj = distance[i][k] + distance[k][j];
          if (distance_ikj < distance[i][j])
            distance[i][j] = distance_ikj;
        }
}


void add_edge (char A, char B)
{
  int i = (A == '*') ? EARTH : A-'A';
  int j = (B == '*') ? EARTH : B-'A';
  
  distance[i][j] = 1;
  distance[j][i] = 1;
}


void initialize (void)
{
  int i, j;

  for (i = 0; i < N; ++i)
    for (j = 0; j < N; ++j)
      distance[i][j] = INFINITY;

  for (i = 0; i < N; ++i)
    value[i] = 0.0;
}


double import_value (int planet)
{
  if (distance[EARTH][planet] < INFINITY)
    return
      pow (0.95, distance[EARTH][planet] - 1) * value[planet];
  else
    return 0.0;
}


void find_best ()
{
  double best = 0.0;
  int i, planet = 0;

  for (i = 0; i < EARTH; ++i)
    {
      double v = import_value (i);
      if (v > best)
        {
          best   = v;
          planet = i;
        }
    }

  fprintf (outfile, "Import from %c\n", planet + 'A');
}
      

void do_galaxy (void)
{
  int i, j, planets;
  
  initialize ();
  fscanf (infile, "%d\n", &planets);

  for (i = 0; i < planets; ++i)
    {
      double v;
      char p, neighbor[N];
      
      fscanf (infile, "%c %lf %s\n", &p, &v, neighbor);

      value[p-'A'] = v;
      for (j = 0; j < strlen (neighbor); ++j)
        add_edge (p, neighbor[j]);
    }

  Floyd_Warshall ();
  find_best ();
}
  
  

void main (void)
{
  infile  = fopen (INPUT_FILE_NAME, "rt");
  outfile = fopen (OUTPUT_FILE_NAME, "wt");

  while (! feof (infile)) do_galaxy ();

  fclose (infile);
  fclose (outfile);
}
