#include <math.h>
#include <fstream.h>


long numpieces;
short pieces [5][4][4];
long piecerows[5];
long piececols[5];
short board[4][4];

ifstream infile = "puzzle.in";
ofstream outfile = "puzzle.out";


int read_input ( void ) {
   char line[11];
   infile >> numpieces;
   if (numpieces == 0) return 0;
   for (long i = 0; i < numpieces; i++) {
      infile >> piecerows[i] >> piececols[i];
      for (long j = 0; j < piecerows[i]; j++) {
         infile >> line;
         for (long k = 0; k < piececols[i]; k++) {
            if (line[k] == '1')
               pieces[i][j][k] = 1;
            else
               pieces[i][j][k] = 0;
         }
      }
   }
   return 1;
}


long fit (long curtry) {
   long i, j, k;
   long boardpos, boardrow, boardcol;
   long solved = 0;
   for (i = 0; i < 4; i++)
      for (j = 0; j < 4; j++)
         board[i][j] = 0;
   for (i = 0; i < numpieces; i++) {
      boardpos = (long)(curtry % (long)pow (16, i+1)) / (long)pow (16, i);
      boardrow = (boardpos / 4);
      boardcol = (boardpos % 4);
      for (j = 0; j < piecerows[i]; j++)
         for (k = 0; k < piececols[i]; k++)
            if ((boardrow+j < 4) && (boardcol+k < 4))
               board[boardrow+j][boardcol+k] += pieces[i][j][k];
   }
   solved = 1;
   for (i = 0; i < 4; i++)
      for (j = 0; j < 4; j++)
         solved = solved && (board[i][j] == 1);
   return solved;
}


long solve (long& answer) {
   long solved = 0;
   long numtries = 1;
   long curtry;
   for (long x = 1; x <= numpieces; x++)
      numtries *= 16;
   for (curtry = 0; (curtry < numtries) && (solved == 0); curtry++)
      if (fit (curtry))
         solved = 1; 
   answer = curtry - 1;
   return solved;
}


void dump_output (long answer) {
   long pos, row, col;
   if (answer == -1)
      outfile << "No solution possible" << endl;
   else {
      char b[4][4];
      int r, c;
      for (int i = 0; i < numpieces; i++) {
         pos = (long)(answer % (long)pow (16, i+1)) / (long)pow (16, i);
         row = pos / 4;
         col = pos % 4;
         for (r = 0; r < piecerows[i]; r++)
            for (c = 0; c < piececols[i]; c++)
               if (pieces[i][r][c]) b[row+r][col+c] = '1' + i;
      }
      for (r = 0; r < 4; r++) {
         for (c = 0; c < 4; c++) outfile << b[r][c];
         outfile << endl;
      }
   }
   outfile << endl;
}

void main() {
   long answer;
   while (read_input()) {
      if (solve (answer))
         dump_output (answer);
      else
         dump_output (-1);
   }
}
