/*---------------------------------------------------------------------------*\
  sequence.cpp - Letter Sequence Analysis - Turbo C++ 3.0
  1995 ACM Mid-Central Regional Programming Contest
  Judge's Solution by Ron Pacheco <pacheco@harding.edu>
  Harding University Computer Science Department
\*---------------------------------------------------------------------------*/

#include <ctype.h>
#include <fstream.h>
#include <string.h>

ofstream out = "sequence.out";

struct node {
   char seq[6];
   int freq;
   node* next;
};
node* list = NULL;

char sequence[6];
int seqlen;


int isaseq() {
   if (strlen( sequence ) < seqlen) return 0;
   for (int i = 0; i < seqlen; i++)
      if (!isalpha( sequence[i] )) return 0;
   return 1;
}


void addchar( char c ) {
   int n = strlen( sequence );
   if (n < seqlen) {
      sequence[n] = c;
      sequence[n+1] = '\0';
      return;
   }
   for (int i = 0; i < n - 1; i++) sequence[i] = sequence[i+1];
   sequence[n-1] = c;
}


void addseq( char* seq ) {
   if (list == NULL || strcmp( seq, list->seq ) < 0) {
      node* n = new node;
      strcpy( n->seq, seq );
      n->freq = 1;
      n->next = list;
      list = n;
      return;
   }
   if (strcmp( seq, list->seq ) == 0) {
      list->freq += 1;
      return;
   }
   node* p = list;
   while (p->next != NULL && strcmp( seq, p->next->seq ) >= 0) p = p->next;
   if (strcmp( seq, p->seq ) == 0) {
      p->freq += 1;
      return;
   }
   node* n = new node;
   strcpy( n->seq, seq );
   n->freq = 1;
   n->next = p->next;
   p->next = n;
}


void freelist() {
   while (list != NULL) {
      node* d = list;
      list = list->next;
      delete d;
   }
}


void printdelmax() {
   int max = 0;
   node* p = list;
   while (p != NULL) {
      if (p->freq > max) max = p->freq;
      p = p->next;
   }
   if (max == 0) return;
   out << "Frequency = " << max << ", Sequence(s) = (";
   int gotone = 0;
   node* q = NULL;
   p = list;
   while (p != NULL) {
      if (p->freq == max) {
         if (gotone) out << ',';
         out << p->seq;
         gotone = 1;
         node* d = p;
         if (q == NULL)
            list = p->next;
         else
            q->next = p->next;
         p = p->next;
         delete d;
      }
      else {
         q = p;
         p = p->next;
      }
   }
   out << ')' << endl;
}


void report() {
   out << "Analysis for Letter Sequences of Length " << seqlen << endl;
   out << "-----------------------------------------" << endl;
   for (int i = 0; i < 5; i++) printdelmax();
   out << endl;
}
   

void count( int n ) {
   sequence[0] = '\0';
   seqlen = n;
   ifstream in = "sequence.in";
   int c;
   c = in.get();
   while (c != EOF) {
      addchar( toupper( char( c ) ) );
      if (isaseq()) addseq( sequence );
      c = in.get();
   }
   in.close();
   report();
   freelist();
}


void main() {
   for (int i = 1; i <= 5; i++) count( i );
}
