program haiku_review;

var
  input_file, output_file: text;
  haiku: string;


function is_vowel (c: char): boolean;
begin
  is_vowel := (c='a') or (c='e') or (c='i') or (c='o') or (c='u') or (c='y');
end;


function count_syllables (i: integer; j: integer): integer;
(*
  Returns the number of syllables in the substring at positions i..j,
  *exclusive*.  The number of syllables equals the number of contiguous
  vowel sequences.
*)  
var
  k, n: integer;
  vowel_sequence: boolean;
begin
  n := 0;
  vowel_sequence := false;
  for k := i+1 to j-1 do
    if is_vowel(haiku[k]) then begin
      if not vowel_sequence then begin
        n := n+1;
        vowel_sequence := true;
      end
    end else
      vowel_sequence := false;
  writeln ('"', copy (haiku, i+1, j-i-1), '": ', n, ' syllable(s).');
  count_syllables := n;      
end;


function check_line (line: integer; syllables: integer): boolean;
begin
  case line of
    1: check_line := (syllables = 5);
    2: check_line := (syllables = 7);
    3: check_line := (syllables = 5);
  end;
end;


function analyze (haiku: string): integer;
var i,j,line: integer;
begin
  i := 0;
  writeln;
  for line := 1 to 3 do begin
    write ('Line ', line, ': ');
    j := i+1;
    repeat j := j+1 until haiku[j] = '/';
    if not check_line(line, count_syllables(i,j)) then begin
      analyze := line;
      exit {analyze};
    end;
    i := j;
  end;
  analyze := 0;
end;


begin
  assign (input_file, 'haiku.in'); reset (input_file);
  assign (output_file, 'haiku.out'); rewrite (output_file);
  repeat
    readln (input_file, haiku);
    if haiku <> 'e/o/i' then
      case analyze(haiku + '/') of
        0: writeln (output_file, 'Y');
        1: writeln (output_file, '1');
        2: writeln (output_file, '2');
        3: writeln (output_file, '3');
      end;
  until haiku = 'e/o/i';
  close (input_file); close (output_file);
end.
