program skew_binary;

var
  input_file: text;
  output_file: text;
  skew: string;


function digit (c: char): longint;
begin
  case c of
    '0': digit := 0;
    '1': digit := 1;
    '2': digit := 2;
  end
end;


function translate (s: string): longint;
var
  i: integer;
  n: longint;
  power_of_2: longint;
begin
  n := 0;
  power_of_2 := 2;
  for i := length(s) downto 1 do begin
    n := n + digit(s[i])*(power_of_2 - 1);
    power_of_2 := power_of_2 * 2;
  end;
  translate := n;
end;


begin
  assign (input_file, 'skew.in'); reset (input_file);
  assign (output_file, 'skew.out'); rewrite (output_file);
  repeat
    readln (input_file, skew);
    if skew <> '0' then writeln (output_file, translate (skew));
  until skew = '0';
  close (input_file); close (output_file);
end.

