// sums.cpp   Andy Harrington Loyola University Chicago 10/2/97

#include <fstream.h>

const MAXSIZE = 12;
int numberOfSolutions, listlength, list[MAXSIZE];
int used[MAXSIZE];  // used[i] is 1 if list[i] is used in the sum

ifstream inf("sum.in");
ofstream outf("sum.out");

void findSum (int sum, int iEnd, int numSkipped)
{
  // Sum is remaining sum left to find from list[iEnd] onward.
  // NumSkipped is value of x[iEnd-1] if is was skipped or else -1.
  // Do not use any later copies of numSkipped to avoid duplication.
  
  if (iEnd == listlength) return;
    
  int newsum = sum - list[iEnd];
  
  if ((numSkipped != list[iEnd])&&(newsum >= 0))
  { // can use list[iEnd]
    used[iEnd] = 1;
    if (newsum == 0)
    { // have solution
      numberOfSolutions++;
      for (int i = 0; i<iEnd; i++)
        if (used[i]) outf << list[i] << '+';
      outf << list[iEnd] << endl;
    }        
    else
      findSum(newsum, iEnd+1, -1);
  }
  
  used[iEnd] = 0;  // also can try not using x[iEnd] in the sum
  findSum(sum, iEnd+1, list[iEnd]);
	// note recursion with larger starting value was done first
	//   to ensure proper output order
}

void main()
{
  int sum;
  while (1)
  {
    inf >> sum >> listlength;
    if (listlength == 0) break;
    for (int i=0; i < listlength; i++) inf >> list[i];
    outf << "Sums of " << sum << ":" << endl;
    numberOfSolutions = 0;
    findSum(sum, 0, -1);
    if (numberOfSolutions == 0) outf << "NONE" << endl;
  }
}
