<HTML>
<HEAD>
  <META NAME="GENERATOR" CONTENT="Adobe PageMill 2.0 Mac">
  <TITLE>Problem F sample solution</TITLE>
</HEAD>
<BODY>

<PRE>
/*
   ACM North Central Region, 1993-94
   Problem F, PostScript Emulation

   Ed Karrels, March 1996
*/

#include &lt;stdio.h>
#include &lt;math.h>

typedef struct Trans {
   int type;
   float x, y;
   struct Trans *next;
} Trans;

char cmds[7][10] = {&quot;rotate&quot;, &quot;translate&quot;, &quot;scale&quot;, &quot;moveto&quot;,
		    &quot;rmoveto&quot;, &quot;lineto&quot;, &quot;rlineto&quot;};

int ReadMove(float *x, float *y) {
   char cmd[20];
   int i;
   
   scanf(&quot;%f %f&quot;, x, y);
   scanf(&quot;%s&quot;, cmd);
   for (i=0; i&lt;7; i++) {
      if (!strcmp(cmd, cmds[i])) return i+1;
   }
   return 0;
}

void Xlate(float *x, float *y, Trans *tr) {
   float tx, ty;

   /* printf(&quot;Tr %.2f %.2f\n&quot;, *x, *y); */
   while (tr) {
      switch (tr-&gt;type) {
       case 1:
	 tx = *x * cos(tr-&gt;x) - *y * sin(tr-&gt;x);
	 *y = *x * sin(tr-&gt;x) + *y * cos(tr-&gt;x);
	 *x = tx;
	 break;
       case 2:
	 *x += tr-&gt;x;
	 *y += tr-&gt;y;
	 break;
       case 3:
	 *x *= tr-&gt;x;
	 *y *= tr-&gt;y;
	 break;
      }
      /* printf(&quot;-&gt; %.2f %.2f\n&quot;, *x, *y); */
      tr = tr-&gt;next;
   }
}


int main() {
   Trans *head_t = 0, *tail_t, *tr;
   int movetype;
   float x, y, cur_x, cur_y, tx, ty;
   
   while (movetype = ReadMove(&amp;x, &amp;y)) {
      if (movetype &lt; 4) {
	 tr = (Trans*)malloc(sizeof(Trans));
	 tr-&gt;type = movetype;
	 tr-&gt;x = x;
	 tr-&gt;y = y;
	 tr-&gt;next = 0;
	 if (!head_t) {
	    head_t = tail_t = tr;
	 } else {
	    tr-&gt;next = head_t;
	    head_t = tr;
	 }

	 switch (tr-&gt;type) {
	  case 1:
	    tr-&gt;x *= 3.141592653 / 180.0;
	    tx    = cur_x * cos(-tr-&gt;x) - cur_y * sin(-tr-&gt;x);
	    cur_y = cur_x * sin(-tr-&gt;x) + cur_y * cos(-tr-&gt;x);
	    cur_x = tx;
	    break;
	  case 2:
	    cur_x -= tr-&gt;x;
	    cur_y -= tr-&gt;y;
	    break;
	  case 3:
	    cur_x /= tr-&gt;x;
	    cur_y /= tr-&gt;y;
	    break;
	 }

      } else {
	 
	 switch (movetype) {
	  case 4:
	    cur_x = x;
	    cur_y = y;
	    Xlate(&amp;x, &amp;y, head_t);
	    printf(&quot;%g %g moveto\n&quot;, x, y);
	    break;
	  case 5:
	    tx = cur_x; ty = cur_y;
	    cur_x += x; x = cur_x;
	    cur_y += y; y = cur_y;
	    Xlate(&amp;x, &amp;y, head_t);
	    Xlate(&amp;tx, &amp;ty, head_t);
	    printf(&quot;%g %g rmoveto\n&quot;, x-tx, y-ty);
	    break;
	  case 6:
	    cur_x = x;
	    cur_y = y;
	    Xlate(&amp;x, &amp;y, head_t);
	    printf(&quot;%g %g lineto\n&quot;, x, y);
	    break;
	  case 7:
	    tx = cur_x; ty = cur_y;
	    cur_x += x; x = cur_x;
	    cur_y += y; y = cur_y;
	    Xlate(&amp;x, &amp;y, head_t);
	    Xlate(&amp;tx, &amp;ty, head_t);
	    printf(&quot;%g %g rlineto\n&quot;, x-tx, y-ty);
	    break;
	 }
      }
   }

   return 0;
}</PRE>
</BODY>
</HTML>
