<HTML>
<HEAD>
  <META NAME="GENERATOR" CONTENT="Adobe PageMill 2.0 Mac">
  <TITLE>Problem F sample solution</TITLE>
</HEAD>
<BODY>

<PRE>
/*
   ACM North Central Region, 1993-94
   Problem F, PostScript Emulation

   Ed Karrels, March 1996
*/

#include &lt;stdio.h>
#include &lt;math.h>

typedef float matrix[3][3];

char *cmds[7] = {&quot;rotate&quot;, &quot;translate&quot;, &quot;scale&quot;, &quot;moveto&quot;,
		 &quot;rmoveto&quot;, &quot;lineto&quot;, &quot;rlineto&quot;};

int ReadMove(float *x, float *y) {
   char cmd[20];
   int i;
   
   scanf(&quot;%f %f&quot;, x, y);
   scanf(&quot;%s&quot;, cmd);
   for (i=0; i&lt;7; i++) {
      if (!strcmp(cmd, cmds[i])) return i+1;
   }
   return 0;
}

void Xlate(float *x, float *y, matrix m) {
   float nx, ny;

   nx = m[0][0] * *x + m[0][1] * *y + m[0][2];
   ny = m[1][0] * *x + m[1][1] * *y + m[1][2];

   *x = nx;
   *y = ny;
}


void PrintMatrix(matrix a) {
   int i, j;

   for (i=0; i&lt;3; i++) {
      for (j=0; j&lt;3; j++) {
	 printf(&quot;%7.2f&quot;, a[i][j]);
      } putchar('\n');
   }
   putchar('\n');
}


/*
   b &lt;- a * b
*/
void MatrixMult(matrix a, matrix b) {
   matrix c;
   int i, j, k;

   for (i=0; i&lt;3; i++)
      for (j=0; j&lt;3; j++) {
	 c[i][j] = 0;
	 for (k=0; k&lt;3; k++)
	    c[i][j] += a[i][k] * b[k][j];
      }
   for (i=0; i&lt;3; i++)
      for (j=0; j&lt;3; j++)
	 a[i][j] = c[i][j];
}


void IdentMatrix(matrix a) {
   int i, j;
   for (i=0; i&lt;3; i++)
      for (j=0; j&lt;3; j++)
	 a[i][j] = 0;
   for (i=0; i&lt;3; i++)
      a[i][i] = 1;
}
	    
   

int main() {
   int movetype;
   float x, y, cur_x=0, cur_y=0, tx, ty;
   matrix xform_matrix, mx;
   
   IdentMatrix(xform_matrix);

   while (movetype = ReadMove(&amp;x, &amp;y)) {
      if (movetype &lt; 4) {
	 IdentMatrix(mx);
	 switch (movetype) {
	  case 1:
	    x *= 3.141592653 / 180.0;
	    tx    = cur_x * cos(-x) - cur_y * sin(-x);
	    cur_y = cur_x * sin(-x) + cur_y * cos(-x);
	    cur_x = tx;
	    mx[0][0] = cos(x); mx[0][1] = -sin(x);
	    mx[1][0] = sin(x); mx[1][1] =  cos(x);
	    break;
	  case 2:
	    cur_x -= x;
	    cur_y -= y;
	    mx[0][2] = x;
	    mx[1][2] = y;
	    break;
	  case 3:
	    cur_x /= x;
	    cur_y /= y;
	    mx[0][0] = x;
	    mx[1][1] = y;
	    break;
	 }
	 MatrixMult(xform_matrix, mx);

      } else {
	 
	 switch (movetype) {
	  case 4:
	    cur_x = x;
	    cur_y = y;
	    Xlate(&amp;x, &amp;y, xform_matrix);
	    printf(&quot;%g %g moveto\n&quot;, x, y);
	    break;
	  case 5:
	    tx = cur_x; ty = cur_y;
	    cur_x += x; x = cur_x;
	    cur_y += y; y = cur_y;
	    Xlate(&amp;x, &amp;y, xform_matrix);
	    Xlate(&amp;tx, &amp;ty, xform_matrix);
	    printf(&quot;%g %g rmoveto\n&quot;, x-tx, y-ty);
	    break;
	  case 6:
	    cur_x = x;
	    cur_y = y;
	    Xlate(&amp;x, &amp;y, xform_matrix);
	    printf(&quot;%g %g lineto\n&quot;, x, y);
	    break;
	  case 7:
	    tx = cur_x; ty = cur_y;
	    cur_x += x; x = cur_x;
	    cur_y += y; y = cur_y;
	    Xlate(&amp;x, &amp;y, xform_matrix);
	    Xlate(&amp;tx, &amp;ty, xform_matrix);
	    printf(&quot;%g %g rlineto\n&quot;, x-tx, y-ty);
	    break;
	 }
      }
   }

   return 0;
}

	    
      
</PRE>
</BODY>
</HTML>
