<HTML>
<HEAD>
  <META NAME="GENERATOR" CONTENT="Adobe PageMill 2.0 Mac">
  <TITLE>Problem G sample solution</TITLE>
</HEAD>
<BODY>

<PRE>
/*
   ACM North Central Region, 1993-94
   Problem G, Inventory Maintenance

   Ed Karrels, March 1996
*/

#include &lt;stdio.h&gt;

typedef struct {
   char name[11];
   int on_hand;
   float buy, sell;
} Ware;

int Read(char **name, int *i1, float *f1, float *f2) {
   static char str[20];

   *name = str;
   scanf(&quot;%s&quot;, str);
   if (!strcmp(str, &quot;report&quot;)) return 5;
   if (!strcmp(str, &quot;new&quot;)) {
      scanf(&quot;%s %f %f&quot;, str, f1, f2);
      return 1;
   } else if (!strcmp(str, &quot;delete&quot;)) {
      scanf(&quot;%s&quot;, str);
      return 2;
   } else if (!strcmp(str, &quot;buy&quot;)) {
      scanf(&quot;%s %d&quot;, str, i1);
      return 3;
   } else if (!strcmp(str, &quot;sell&quot;)) {
      scanf(&quot;%s %d&quot;, str, i1);
      return 4;
   } else {
      return 0;
   }
}   

int Cmp(const void *av, const void *bv) {
   Ware *a = (Ware*)av;
   Ware *b = (Ware*)bv;
   return strcmp(a-&gt;name, b-&gt;name);
}

int Lookup(Ware w[], int nw, char *name) {
   int i;
   for (i=0; i&lt;nw; i++)
      if (!strcmp(w[i].name, name))
	 return i;

   return 0;
}

int main() {
   Ware w[100];
   int nw, cmd, i, in;
   float f, g, profit = 0;
   char *name;

   while (cmd = Read(&amp;name, &amp;i, &amp;f, &amp;g)) {
      if (cmd == 5) {
	 qsort(w, nw, sizeof(Ware), Cmp);
	 printf(&quot;%35s&quot;, &quot;INVENTORY REPORT\n&quot;);
	 printf(&quot;Item Name     Buy At      Sell At      On Hand        Value\n&quot;);
	 printf(&quot;---------     ------      -------      -------        -----\n&quot;);
	 f = 0;
	 for (i=0; i&lt;nw; i++) {
	    printf(&quot;%-14s%6.2f%13.2f%13d%13.2f\n&quot;, w[i].name, w[i].buy,
		   w[i].sell, w[i].on_hand, w[i].on_hand * w[i].buy);
	    f += w[i].on_hand * w[i].buy;
	 }
	 printf(&quot;------------------------\n&quot;);
	 printf(&quot;Total value of inventory %34.2f\n&quot;, f);
	 printf(&quot;Profit since last report %34.2f\n\n&quot;, profit);
	 profit = 0;
      } else {
	 if (cmd != 1) in = Lookup(w, nw, name);
	 switch (cmd) {
	  case 1:
	    strcpy(w[nw].name, name);
	    w[nw].buy = f;
	    w[nw].sell = g;
	    w[nw].on_hand = 0;
	    nw++;
	    break;
	  case 2:
	    profit -= w[in].on_hand * w[in].buy;
	    w[in] = w[--nw];
	    break;
	  case 3:
	    w[in].on_hand += i;
	    break;
	  case 4:
	    profit += i * (w[in].sell - w[in].buy);
	    w[in].on_hand -= i;
	    break;
	 }
      }
   }
   return 0;
}</PRE>
</BODY>
</HTML>
