/*
   1996 ACM North Central Regional Programming Contest
   Problem A -- It's Ir-Resist-Able

   Ed Karrels, November 1996
*/

#include <stdio.h>

typedef struct {
    int a, b;
    float ohm;
} Resistor;

Resistor resist[30];
int n_resist, from, to;


int Pt2Resist(int pt, int r) {
    return resist[r].a == pt ||
	   resist[r].b == pt;
}

int InSeries(int r1, int r2) {
    int x, y;
    x = Pt2Resist(resist[r1].a, r2);
    y = Pt2Resist(resist[r1].b, r2);
    return (x && !y) || (!x && y);
}

int InParallel(int r1, int r2) {
    return Pt2Resist(resist[r1].a, r2) &&
	   Pt2Resist(resist[r1].b, r2);
}

int OtherConnected(int pt, int r1, int r2) {
    int i;

    for (i=0; i<n_resist; i++) {
	if (i==r1 || i==r2) continue;
	if (resist[i].a == pt || resist[i].b == pt)
	    return 1;
    }
    return 0;
}


void ElimStrays() {
    int r, i, a_con, b_con, found_one = 0;

    do {
	found_one = 0;
	for (r=0; r<n_resist; r++) {
	    if (Pt2Resist(from, r) || Pt2Resist(to, r)) continue;

	    a_con = b_con = 0;
	    for (i=0; i<n_resist; i++) {
		if (i!=r) {
		    if (Pt2Resist(resist[r].a, i)) a_con=1;
		    if (Pt2Resist(resist[r].b, i)) b_con=1;
		}
	    }
	    if (!a_con || !b_con) {
		/*
		printf("Stray %d between %d and %d\n", r,
		       resist[r].a, resist[r].b);
		*/
		found_one = 1;
		resist[r] = resist[--n_resist];
		r--;
	    }
	}
    } while (found_one);
}
	

int ElimSeries() {
    int r1, r2, connect, found_one=0;
    Resistor combined;

    for (r1=0; r1<n_resist; r1++) {
	for (r2=r1+1; r2<n_resist; r2++) {
	    if (InSeries(r1, r2)) {
		connect = Pt2Resist(resist[r1].a, r2)
		    ? resist[r1].a : resist[r1].b;
		
		if (connect != from &&
		    connect != to &&
		    !OtherConnected(connect, r1, r2)) {
		    /*
		    printf("Series %d, %d  at point %d\n", r1, r2, connect);
		    */
		    found_one = 1;
		    combined.a = (resist[r1].a == connect)
			? resist[r1].b
			: resist[r1].a;
		    combined.b = (resist[r2].a == connect)
			? resist[r2].b
			: resist[r2].a;
		    combined.ohm = resist[r1].ohm + resist[r2].ohm;
		    resist[r1] = combined;
		    resist[r2] = resist[--n_resist];
		    r2--;
		}
	    }
	}
    }
    return found_one;
}

int ElimParallel() {
    int r1, r2, found_one=0;
    float ohm;

    for (r1=0; r1<n_resist; r1++) {
	ohm = 1 / resist[r1].ohm;
	for (r2=r1+1; r2 < n_resist; r2++) {
	    if (InParallel(r1, r2)) {
		/*
		printf("Parallel %d, %d between %d and %d\n",
		       r1, r2, resist[r1].a, resist[r1].b);
		*/
		found_one = 1;
		ohm += 1 / resist[r2].ohm;
		resist[r2] = resist[--n_resist];
		r2--;
	    }
	}
	resist[r1].ohm = 1 / ohm;
    }
    return found_one;
}

    
int main() {
    int c=1, r, i;

    while (scanf("%d %d %d", &n_resist, &from, &to), n_resist || from || to) {
	for (i=0; i<n_resist; i++) {
	    scanf("%d %d %f", &resist[i].a, &resist[i].b, &resist[i].ohm);
	}

	while (ElimStrays(), ElimSeries(), ElimParallel());

	for (r=0; r<n_resist; r++) {
	    if (Pt2Resist(from, r) && Pt2Resist(to, r))
		break;
	}
	if (r == n_resist) {
	    printf("No circuit from %d to %d.\n", from, to);
	} else {
	    printf("Case %d: %.2f Ohms\n", c++, resist[r].ohm);
	}
    }

    return 0;
}

