/*
   1996 ACM North Central Regional Programming Contest
   Problem B -- Getting Chorded

   Ed Karrels, November 1996
*/

#include <stdio.h>
#include <ctype.h>

char *names[12] = {"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A",
		   "A#", "B"};

char *Note2Str(int note) {
   return names[note];
}

int Str2Note(char *str) {
   char note;
   int val;

   note = tolower(*str);
   if (note >= 'c' && note <= 'e') {
      val = (note - 'c') * 2;
   } else if (note >= 'f') {
      val = (note - 'c') * 2 - 1;
   } else {
      val = (note - 'a') * 2 + 9;
   }

   if (str[1] == '#') {
      val++;
      if (val == 12) val = 0;
   } else if (tolower(str[1]) == 'b') {
      val--;
      if (val == -1) val = 11;
   }
   return val;
}


int main() {
   char str1[5], str2[5], str3[5];
   int a[40], i, note;

   while (scanf("%s %s %s", str1, str2, str3) != EOF) {
      for (i=0; i<40; i++) a[i] = 0;
      note = Str2Note(str1);
      a[note] = a[note+12] = 1;
      note = Str2Note(str2);
      a[note] = a[note+12] = 1;
      note = Str2Note(str3);
      a[note] = a[note+12] = 1;

      for (i=0; i<11; i++) {
	 if (a[i] && a[i+4] && a[i+7]) {
	    printf("%s %s %s is a %s Major chord.\n", str1, str2, str3,
		   Note2Str(i));
	    goto got_it;
	 }

	 if (a[i] && a[i+3] && a[i+7]) {
	    printf("%s %s %s is a %s Minor chord.\n", str1, str2, str3,
		   Note2Str(i));
	    goto got_it;
	 }
      }
      printf("%s %s %s is unrecognized.\n", str1, str2, str3);
   got_it:
   }

   return 0;
}
