/*
   1996 ACM North Central Regional Programming Contest
   Problem E -- Transferable voting

   Ed Karrels, November 1996
*/

int ncand, nvoters, v[100][5];

typedef struct {
   int cand;
   int nvotes;
} Rank;


int CompareRank(const void *a, const void *b) {
   return ((Rank*)b)->nvotes - ((Rank*)a)->nvotes;
}

void Tally(Rank ranking[5]) {
   int i, tally[5] = {0};

   for (i=0; i<nvoters; i++)
      if (v[i][0] != -1)
	 tally[v[i][0] - 1]++;

   for (i=0; i<5; i++) {
      ranking[i].cand = i+1;
      ranking[i].nvotes = tally[i];
   }

   qsort(ranking, 5, sizeof(Rank), CompareRank);

   /*
   printf("Ranking:\n");
   for (i=0; i<5; i++) {
      printf("   %2d %2d\n", ranking[i].cand, ranking[i].nvotes);
   }
   */
}

int Valid(int a[]) {
   int voted[5] = {0}, i;

   for (i=0; i<ncand; i++) {
      if (a[i] < 0 || a[i] > ncand) return 0;
      if (voted[a[i]-1]) return 0;
      voted[a[i]-1] = 1;
   }

   return 1;
}

void Elim(int cand) {
   int i, j;

   for (i=0; i<nvoters; i++) {
      for (j=0; v[i][j] != cand; j++);
      for (; j<ncand-1; j++) {
	 v[i][j] = v[i][j+1];
      }
      v[i][ncand-1] = -1;
   }

}
      

int main() {
   int i, j, n_invalid, c=0, elim[5], n_cand_left, tied;
   Rank ranking[5];

   while (scanf("%d %d", &ncand, &nvoters), ncand || nvoters) {
      n_invalid = 0;
      for (i=0; i<nvoters; i++) {
	 for (j=0; j<ncand; j++) {
	    scanf("%d", &v[i][j]);
	 }
	 if (!Valid(v[i])) {
	    n_invalid++;
	    nvoters--;
	    i--;
	 }
      }

      for (i=0; i<ncand; i++) elim[i] = 0;

      printf("Election #%d\n", ++c);
      if (n_invalid)
	 printf("   %d bad ballot(s)\n", n_invalid);
      
      n_cand_left = ncand;
      while (1) {
	 /*
	 printf("Votes:\n");
	 for (i=0; i<nvoters; i++) {
	    for (j=0; j<ncand; j++) {
	       printf("%2d ", v[i][j]);
	    } putchar('\n');
	 }
	 */

	 Tally(ranking);

	 if (ranking[0].nvotes * 2 > nvoters) {
	    printf("   Candidate %d is elected.\n", ranking[0].cand);
	    break;
	 }

	 tied = 1;
	 for (i=0; i<n_cand_left; i++) {
	    tied = tied && (ranking[0].nvotes == ranking[i].nvotes);
	 }

	 if (tied) {
	    printf("   The following candidates are tied:");
	    for (i=0; i<5 && ranking[i].nvotes == ranking[0].nvotes; i++) {
	       printf(" %d", ranking[i].cand);
	    } putchar('\n');
	    break;
	 }

	 Elim(ranking[--n_cand_left].cand);
      }
   }

   return 0;
}
