{ACM NEERC, St.Petersburg-Barnaul, December 3, 1996}
{Turing Machine Interpreter}

{$A-,B-,D+,E-,F+,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}

program Turing_Interpreter;
uses CRT;

const MaxStates = 3000;
      MSize = 65520;
      OutSize = 65520;
      ErrorInt = -9999;

type TValue = (_0, _1, _E);
     TM = array [1..MSize] of TValue;
     TOut = array [1..OutSize] of char;
     TTable = array [1..MaxStates, TValue] of
                       record
                          q: 0..MaxStates;
                          e: TValue;
                          Shift: shortint;
                          o: char;
                       end;

var inf: TEXT;

    M: ^TM; OUT: ^TOut;
    MFrom, MTo, MPtr, MStartPtr: longint;
    Table: TTable;

    OutPtr: word;
    MValuesOnScreen: integer;
    MWindowPtr: longint;

    N: integer;
    CurState, StartState: integer;

    Actions: longint;

function VisualValue (v: TValue): char;
begin
   case v of
     _0: VisualValue := '0';
     _1: VisualValue := '1';
     _E: VisualValue := 'E';
   else
       VisualValue := '?';
   end;
end;

procedure BEEP;
begin
   sound (650); delay (59); nosound;
end;

function Str (x: longint; w: integer): string;
var help: string; rc: integer;
begin
   System.Str (x:w, help);
   Str := help
end;

procedure Split (s: string; c: char; var s1, s2: string);
var i, j: integer;
begin
   i := 1; while (i <= length (s)) and (s [i] =  ' ') do inc (i);
   j := i; while (j <= length (s)) and (s [j] <> c) do inc (j);
   s1 := copy (s, i, j-i);
   s2 := copy (s, j, length (s)-j+1);
end;

function compress (s: string): string;
begin
   while (length (s) > 1) and (s [1] = ' ') do delete (s, 1, 1);
   while (length (s) > 1) and (s [length(s)] = ' ') do delete (s, length(s), 1);
   compress := s
end;

function VisualNextMove: string; forward;

procedure DrawScreen;
const MWindowSize = 19;
      OWindowSize = 70;
var i: integer;
    ch: char;
    p: word;
    OWindowPtr: longint;
    help: string;
begin
   ClrScr;
   writeln ('Memory (M): ');

   for i := 1 to 19 do write (''); write (''); writeln;

   if MPtr < MWindowPtr then MWindowPtr := MPtr
   else if MPtr >= MWindowPtr + MWindowSize then MWindowPtr := MPtr-MWindowSize+1;

   for i := 1 to MWindowSize do
   begin
      write (' ');
      p := MWindowPtr + i - 1;
      if (p < MFrom) or (p > MTo) then write ('E ')
      else write (VisualValue (M^ [p]), ' ');
   end;

   writeln ('');
   for i := 1 to MWindowSize do write (''); writeln ('');
   write ('  ');
   for i := 1 to MPtr - MWindowPtr do write ('    ');
   writeln ('');

   help := '(' + Str (MPtr - MStartPtr, 0) + ')';
   if MPtr - MWindowPtr + 1 <> MWindowSize then
   begin
      write ('  ');
      for i := 1 to MPtr - MWindowPtr do write ('    ');
   end
   else
      for i := 1 to 3 + (MPtr - MWindowPtr)*4 - length (help) do write (' ');

   writeln (help);


   writeln;
   write ('Output: ');
   if OutPtr > OWindowSize then
   begin
      write ('');
      OWindowPtr := OutPtr - OWindowSize + 1
   end else OWindowPtr := 1;

   for i := OWindowPtr to OutPtr do write (Out ^ [i]);
   writeln;
   writeln;
   writeln ('Current state number : ', CurState);
   writeln ('Next action          : ', VisualNextMove);
   writeln ('Actions perfomed     : ', Actions);
   writeln;
end;

procedure QUIT (msg: string);
begin
   writeln (#13, '                    ' );
   writeln (msg);
   HALT;
end;

procedure RIGHT;
begin
   inc (MPtr);
   if MPtr > MTo then
   begin
      if MPtr > MSize then QUIT ('Too many cells are used on tape M');
      MTo := MPtr;
      M^ [MPtr] := _E
   end;
end;

procedure LEFT;
begin
   dec (MPtr);
   if MPtr < MFrom then
   begin
      if MPtr < 1 then QUIT ('Line M is too long');
      MFrom := MPtr;
      M^ [MPtr] := _E
   end;
end;

procedure WriteOut (o: char);
begin
   inc (OutPtr);
   if OutPtr > OutSize then QUIT ('Too many values has been written to the output tape');
   Out ^ [OutPtr] := o
end;

procedure WriteM (v: TValue);
begin
   M^ [MPtr] := v
end;

procedure TERMINATED;
var ouf: TEXT;
    i: word;
begin
   DrawScreen;
   writeln ('EXECUTION FINISHED');
   writeln;
   writeln (Actions:5, ' actions were perfomed');
   writeln (longint (MTo) - MFrom + 1: 5, ' values were the maximus head shift');
   writeln;
   if OutPtr <> 0 then
   begin
      assign (ouf, 'TURING.OUT'); rewrite (ouf);
      for i := 1 to OutPtr do write (ouf, Out ^ [i]);
   end;
   close (ouf);
   writeln ('The output (' + Str (Outptr, 0) + ' bytes length) has been written to file TURING.OUT');
   HALT
end;

procedure NextMove;
begin
  with Table [CurState, M^ [MPtr]] do
  begin
     if q = 0 then TERMINATED;

     CurState := q;
     M^ [MPtr] := e;
     if o <> ' ' then WriteOut (o);
     if shift = -1 then LEFT else if shift = 1 then RIGHT
  end;
  inc (Actions);
end;

function VisualNextMove: string;
var help: string;
begin
   with Table [CurState, M^ [MPtr]] do
    if q <> 0 then
    begin
      help := '(' + Str (q, 0) + ', "' + VisualValue (e) + '") Move = ' + Str (shift, 0);
      if o <> ' 'then help := help + ' out = "' + o + '"';
      VisualNextMove := help;
    end
    else VisualNextMove := 'no rule defined';
end;

var e, e1: TValue;
    q, q1: integer;
    move: integer;
    i: integer;
    help, BSK: string;
    sq, se, sq1, se1, smove, sout: string;
    RepeatRules: boolean;
    ch: char;
    Trace, WaitKeyPressed: boolean;
    LastActions: longint;
    instringfile: TEXT;
    LNumber: longint;

    procedure IR;
    begin
        QUIT ('Wrong rule found at line ' + Str (LNumber, 0));
    end;

    function IntValue (s: string): integer;
    var help: string; rc: integer; res: integer;
    begin
       Val (s, res, rc);
       if rc <> 0 then IR ;
       IntValue := res
    end;

    function CharValue (s: string): char;
    begin
       if length (s) <> 1 then IR ;
       CharValue := s [1]
    end;

    function MValue (s: string): TValue;
    begin
      case upcase (CharValue (s)) of
        '1': MValue := _1;
        '0': MValue := _0;
        'E': MValue := _E;
        else QUIT ('unknown symbols: "' + s + '"');
      end;
    end;

BEGIN
   ClrScr;

   New (M); New (Out);
   MPtr := MSize div 2;
   MStartPtr := MPtr;
   MWindowPtr := MPtr - 1;
   MFrom := MPtr; MTo := MPtr;
   M^ [MPtr] := _E;

   LastActions := 0;

   writeln;
   writeln ('1996 ACM NorthEastern European Regional Collegiate Programming Contest');
   writeln ('TOOL for Problem C (Turing calculator)');
   writeln;

   if (ParamCount <> 1) and (ParamCount <> 2) then
   begin
      writeln ('USAGE: TURING.EXE <File_Name> [<Input_File>]');
      writeln;
      writeln ('where <File_Name>   - file with Turing machine program');
      writeln ('      <Input_File>  - file with input string');
      writeln ('                      (if absent input string will be asked from keyboard)');
      HALT
   end;

   assign (inf, ParamStr (1)); reset (inf);
   if IORESULT <> 0 then QUIT ('Can not open file "' + ParamStr (1) + '"');

   LNumber := 0;
   repeat
       if eof (inf) then QUIT ('Eof found: missing number of Machine''s states');
       readln (inf, help); inc (LNumber);
       split (help, ';', help, BSK);
   until eof (inf) or (help <> '');

   N := IntValue (help);

   if N < 0 then QUIT ('The number of states N must be greater than 0');
   if N > MaxStates then QUIT ('The number of states N must be not greater than ' + Str (MaxStates, 0));

   repeat
       if eof (inf) then QUIT ('Eof found: Missing initial state');
       readln (inf, help); inc (LNumber);
       split (help, ';', help, BSK);
   until (eof (inf)) or (help <> '');

   StartState := IntValue (help);

   if (StartState <=  0) or (StartState > N) then QUIT ('Invalid intial state S');

   for i := 1 to N do
     for e := _0 to _E do Table [i,e].q := 0;

   RepeatRules := false;
   while not eof (inf) do
   begin
      inc (LNumber);
      readln (inf, help);

      split (help, ';', help, BSK);

      split (help, ' ', sq, help);
      split (help, ' ', se, help);
      split (help, ' ', sq1, help);
      split (help, ' ', se1, help);
      split (help, ' ', smove, help);
      split (help, ' ', sout, help);

      if sq <> '' then begin
         if sout = '' then sout := ' ';
         sout := CharValue (Sout);
         q := IntValue (sq);
         e := MValue (se);
         q1 := IntValue (sq1);
         e1 := MValue (se1);
         move := IntValue (smove);
         if (q < 0) or (q > N) or (q1 < 0) or (q1 > N) or
            ( not (sout [1] in ['1','0', ' '])) or (move < -1) or (move > 1) then
         IR;

         if (Table [q, e] . q <> 0) and (not RepeatRules) then
            QUIT ('Line ' + Str (LNumber, 0) + ' contains already defined rule');

         Table [q, e] . q := q1;
         Table [q, e] . e := e1;
         Table [q, e] . shift := move;
         Table [q, e] . o := sout [1];
      end;

   end;

   if paramCount = 2 then
   begin
      assign (instringfile, ParamStr (2)); reset (instringfile);
      if IORESULT <> 0 then QUIT ('Can not open file "' + ParamStr (2) + '"');
      help := '';
      while (help = '') and (not eof (instringfile)) do
      begin
         readln (instringfile, help);
         help := compress (help);
      end;
   end
   else begin
      writeln ('Enter Turing input data (a string of "1", "0", "E"): ');
      writeln ('(press enter for exit)');
      readln (help);
      writeln;
   end;

   for i := 1 to length (help) do
   begin
      if upcase (help [i]) = 'E' then e := _E
      else if help [i] = '1' then e := _1
      else if help [i] = '0' then e := _0
      else QUIT ('Wrong symbol your input string: "' + help [i] + '"');
      WriteM (e);
      if i <> length (help) then RIGHT;
   end;

   MPtr := MStartPtr;
   CurState := StartState;

   Trace := true;
   WaitKeyPressed := True;
   Actions := 0;
   LastActions := 0;

   REPEAT

      if Trace then DrawScreen;

      if (not (Trace and WaitKeyPressed)) and (LastActions + 500 < Actions) then
      begin
         LastActions := Actions;
         write (#13, Actions);
      end;

      if WaitKeyPressed then
      begin
         writeln ('<Enter> - Run, <Space> - Trace, <Esc> - Exit or stop running');
         writeln;
         write ('=> '); ch := readkey;
         case ch of
            ' ': NextMove;
            #13: begin
                    WaitKeyPressed := false; Trace := false;
                    writeln ('Running ... ');
                 end;
            #27: TERMINATED;

            else BEEP;
          end;
      end
      else
           NextMove;

      if keypressed then
      begin
          case ReadKey of
             #27: begin WaitKeyPressed := True; Trace := True end;
           end;
      end;

   UNTIL FALSE;

   DrawScreen;
END.