#include <stdio.h>

/*
 * This algorithm was given by Bentley in Cacm, 27(9) on page 867.
 */

#define MAX 100    
#define max(i,j) ((i) > (j) ? (i) : (j))

main()
{
	int array[MAX+1];  /* we'll index the array from 1 */
	int n, i;
	int lowbound, highbound, lo;
	int maxsofar, maxendinghere;

	for(;;) {
		if (scanf("%d", &n) != 1 || n == 0) {
			break;
		}
		for (i = 1 ; i <= n ; i++) {
			scanf("%d", &array[i]);
		}

		maxsofar = 0;
		maxendinghere = 0;
		lo = 1;
		for (i = 1 ; i <= n ; i++) {
			maxendinghere = max(0, maxendinghere + array[i]);
			if (maxendinghere == 0) {
				lo = i+1;
			}
			if (maxendinghere > maxsofar) {
				maxsofar = maxendinghere;
				lowbound = lo;
				highbound = i;
			} else if (maxendinghere == maxsofar &&
				   i - lo < highbound - lowbound) {
				lowbound = lo;
				highbound = i;
			}
		}

		printf("%10d%10d%10d\n", lowbound, highbound, maxsofar);
	}
	return 0;
}
