{ Note on line 5 of the judges problemD.dat there is a point exactly on the
  triangle edge.  According to the instructions this should be counted.  It
  is when this prog is run on the PC, it isn't where the prog is run on
  the Sun (count 1 Vs 0).  Must be a floating point error! }

PROGRAM OrchardTrees;
CONST max = 100;   {Max range of values}

TYPE line = record
              x,y: real;   {coordinates of one end}
            dx,dy: real;   {differences in x and y i.e. x2-x1, y2-y1}
            denom: real;   {denominator in distance calc = sqrt(dx^2 + dy^2)}
               d0: real;   {distance to midpoint of triangle}
            end;

VAR triangle: array[1..3] of line;
    xc, yc: real;                    {centre of triangle}
    i: integer;                      {index}

FUNCTION ReadPoints: Boolean;
VAR i: integer;
    done: Boolean;
    s: string;

begin
  done := true;
  for i := 1 to 3 do
    with triangle[i] do begin
      read(x, y);
      if (x <> 0) or (y <> 0) then done := false;
      end;
  readln(s); if s <> '' then writeln(' too much after points "', s, '"');
  ReadPoints := not done;
end;  {Read Points}

PROCEDURE FixTriangle;
VAR i : integer;
begin
xc := 0.0; yc := 0.0;
for i := 1 to 3 do with triangle[i] do begin
  xc := xc + x; yc := yc + y;
  dx := triangle[i mod 3 + 1].x - x;
  dy := triangle[i mod 3 + 1].y - y;
  denom := sqrt(dx*dx + dy*dy) end;
xc := xc / 3.0; yc := yc / 3.0;
for i := 1 to 3 do with triangle[i] do
  if denom > 0
    then d0 := (dy*(xc - x) - dx*(yc - y))/denom
    else denom := 0.0;
end;  {Fix Triangle}

FUNCTION TriangleCount: integer;
VAR count, i: integer;
    xi, yi: integer;
    xmin, xmax, ymin, ymax: integer;
    d: real;
    tree_in: Boolean;

FUNCTION Ceil(x:real): integer; begin Ceil := round(x + 0.5) end;

begin count := 0;
xmin := max; ymin := max; xmax := 0; ymax := 0;
for i := 1 to 3 do with triangle[i] do begin
  xi := Ceil(x); yi := Ceil(y);
  if xi > xmax then xmax := xi; if yi > ymax then ymax := yi;
  if xi < xmin then xmin := xi; if yi < ymin then ymin := yi;
  xi := trunc(x); yi := trunc(y);
  if xi > xmax then xmax := xi; if yi > ymax then ymax := yi;
  if xi < xmin then xmin := xi; if yi < ymin then ymin := yi;
  end;  {for i := 1 to 3}

if xmin <= 0 then xmin := 1; if ymin <= 0 then ymin := 1;
if xmax >= 100 then xmax := 99; if ymax >= 100 then ymax := 99;
for xi := xmin to xmax do for yi := ymin to ymax do begin
  tree_in := true;
  for i := 1 to 3 do with triangle[i] do begin
    d := (dy*(xi- x) - dx*(yi - y))/denom;
    if (d0 = 0) and (d <> 0)
      then tree_in := false
      else if d * d0 < 0 then tree_in := false;
    end;
  count := count + ord(tree_in);
  end;  {looping thru all potential trees in rectangle 'surrounding' triangle'}
TriangleCount := count;
end;  {Triangle Count}

begin  {Main}

while ReadPoints do begin
  FixTriangle;
  writeln(TriangleCount:4);
  end;  {while Read Points}
end. {of program}
