#include <stdio.h>

typedef struct route_t
{ int  mta_num;
	char name[11], country[11], admd[11], prmd[11], org[11];
}route_t;

typedef struct mta_t
{ char    name[11];
	int     num_entries, visited;
	route_t route[9];
}mta_t;

int     num_mtas;
mta_t   mtas[10];
route_t curr_msg;
FILE    *inp, *outp;

int find_mta_num(char *mta_name)
{ int i;
	for (i=0; i<num_mtas; i++)
	{ if (strcmp(mta_name, mtas[i].name) == 0)
    { return(i); }
  }
}

void read_mtas(void)
{ int i,j;

	fscanf(inp, "%d\n", &num_mtas);
	for (i=0; i<num_mtas; i++)
	{ fscanf(inp, "%s %d\n", &(mtas[i].name), &(mtas[i].num_entries));
		for (j=0; j<mtas[i].num_entries; j++)
		{ fscanf(inp, "%s %s %s %s %s\n", &(mtas[i].route[j].name),
						 &(mtas[i].route[j].country), &(mtas[i].route[j].admd),
						 &(mtas[i].route[j].prmd), &(mtas[i].route[j].org));
		}
	}

	for (i=0; i<num_mtas; i++)
	{ for (j=0; j<mtas[i].num_entries; j++)
		{ mtas[i].route[j].mta_num = find_mta_num(mtas[i].route[j].name); }
  }
}

int check_route(int e_num)
{
	if ((strcmp(mtas[curr_msg.mta_num].route[e_num].country, curr_msg.country)
				&& (mtas[curr_msg.mta_num].route[e_num].country[0] != '*')) ||

	    (strcmp(mtas[curr_msg.mta_num].route[e_num].admd, curr_msg.admd)
				&& (mtas[curr_msg.mta_num].route[e_num].admd[0] != '*'))    ||

	    (strcmp(mtas[curr_msg.mta_num].route[e_num].prmd, curr_msg.prmd)
				&& (mtas[curr_msg.mta_num].route[e_num].prmd[0] != '*'))    ||

	    (strcmp(mtas[curr_msg.mta_num].route[e_num].org, curr_msg.org)
			  && (mtas[curr_msg.mta_num].route[e_num].org[0] != '*')))
  { return(0); }

  return (1);
}

void send_message(void)
{ int i,found;

	for (i=0; i<num_mtas; i++)
	{ mtas[i].visited = 0; }

	while (1)
	{ if (mtas[curr_msg.mta_num].visited)
		{ fprintf(outp, " -- circular routing detected by %s\n",
							mtas[curr_msg.mta_num].name);
      return;
		}

	  for (i=0, found=0; !found && (i<mtas[curr_msg.mta_num].num_entries); )
		{ if (!check_route(i))
			{ i++; }
      else { found++; }
		}

		if (!found)
		{ fprintf(outp, " -- unable to route at %s\n", mtas[curr_msg.mta_num].name);
      return;
		}

		if (curr_msg.mta_num ==	mtas[curr_msg.mta_num].route[i].mta_num)
		{ fprintf(outp, " -- delivered to %s\n", mtas[curr_msg.mta_num].name);
			return;
		}

		mtas[curr_msg.mta_num].visited = 1;
		curr_msg.mta_num = mtas[curr_msg.mta_num].route[i].mta_num;
  }
}

void simulate_messages(void)
{ int num_messages, msg_num;

	fscanf(inp, "%d\n", &num_messages);

	for (msg_num=1; msg_num<=num_messages; msg_num++)
	{ fscanf(inp, "%s %s %s %s %s\n", &curr_msg.name, &curr_msg.country,
								&curr_msg.admd, &curr_msg.prmd, &curr_msg.org);
		curr_msg.mta_num = find_mta_num(curr_msg.name);
		fprintf(outp, "%1d", msg_num);
		send_message();
	}
}

void main(void)
{ int scenario=1;

	inp =fopen("mta.in",  "r");
	outp=fopen("mta.out", "w");

	while (!feof(inp))
	{ fprintf(outp, "Scenario # %1d\n", scenario);
		scenario++;
		read_mtas();
		simulate_messages();
		fprintf(outp, "\n");
	}
	fclose(inp);
  fclose(outp);
}
