#include <stdio.h>
#define C1 1
#define C5 6

unsigned long c5_set_bits[26]=
	 { 0x747f1880, 0xf47d1f00, 0x7c610780, 0xf4631f00, 0xfc390f80, 0xfc390800,
/*       A           B           C           D            E           F   */
		 0x7c271700, 0x8c7f1880, 0xf9084f80, 0x38852600, 0x8cb92880, 0x84210f80,
/*       G           H           I           J            K          L    */
		 0x8eeb1880, 0x8e6b3880, 0x74631700, 0xf47d0800, 0x74633780, 0xf47d2880,
/*       M           N           O           P            Q          R    */
		 0x7c1c1f00, 0xfd484700, 0x8c631700, 0x8c54a200, 0x8c6bb880, 0x8a88a880,
/*       S           T           U           V            W          X    */
		 0x8a884200, 0xf8888f80 };
/*       Y           Z                                                    */

char grid[60][60];
FILE *inp, *outp;

void print_c5_char(int char_index, int row, int col)
{ int j, k;
	unsigned long currbit;

	currbit=0x80000000;
	for (j=0; j<5; j++)
	{ for (k=0; k<5; k++)
		{ if ((c5_set_bits[char_index] & currbit) &&
					((row+j) >= 0) && ((row+j) < 60) &&      /* row truncation    */
					((col+k) >= 0) && ((col+k) < 60))        /* column truncation */
			{ grid[row+j][col+k] = '*'; }
			currbit/=2;
		}
	}
}

void place(char *str, int font, int row, int col)
{ int i;

	for (i=0; i < strlen(str); i++)
	{ if (str[i] != ' ')
		{ if (font == C5)
			{ print_c5_char( (int) str[i]-'A', row, col+(i*font) ); }
			else
			{ if ((row >= 0 ) && (row < 60) && (col+i >= 0) && (col+i < 60))
				{ grid[row][col+i] = str[i]; }
		  }
    }
	}
}

void eject_page(void)
{ int r,c;

	for (r=0; r<60; r++)
	{ for (c=0; c<60; c++)
		{ fprintf(outp, "%1c", grid[r][c]); }
		fprintf(outp, "\n");
	}
	fprintf(outp,"\n------------------------------------------------------------\n\n");
}

void format_paper(void)
{ int font, row, col, i, str_state, eject_flag;
	char command[5], font_id[3], str[61];

	memset(&grid, '.', 3600);  /* initialize to a blank piece of paper */
	memset(&str, 0, 61);
	eject_flag = 0;

	while (!eject_flag)
	{ fscanf(inp, "%s", command);
		if (strcmp(command, ".EOP") == 0)
		{ eject_flag = 1; }

		else
		{ fscanf(inp, "%s %d", &font_id, &row);   /* get the font and row      */
			font = font_id[1] - '0';
			font = font + (font-1)/4;              /* change C5 font to 6       */

			if (strcmp(command, ".P") == 0)         /* get the command for place */
			{ fscanf(inp, "%d", &col); }

			for (str_state=0, i=0; str_state!=2; )  /* get the string            */
			{ fscanf(inp, "%c", &str[i]);
				if (str[i] == '|')
				{ str_state++; }
				else
        { i+=str_state; }
			}
			str[i] = 0;

			if (strcmp(command, ".P") == 0)
			{	place(str, font, row-1, col-1); }
			else if (strcmp(command, ".L") == 0)
			{	place(str, font, row-1, 0); }
			else if (strcmp(command, ".R") == 0)
			{	place(str, font, row-1, 60 - (strlen(str) * font) ); }
			else if (strcmp(command, ".C") == 0)
			{	place(str, font, row-1, 30 - (strlen(str) * font) / 2); }
		}

		fscanf(inp,"\n");
	}
	eject_page();
}

void main(void)
{
	inp  = fopen("post.in",  "r");
	outp = fopen("post.out", "w");

	while (!feof(inp))
	{ format_paper();	}

	fclose(inp);
	fclose(outp);
}
