#include <stdio.h>
#include <math.h>

#define M_PI		3.14159265358979323846
#define SWEEP1  1
#define SWEEP2  2

typedef struct {
	int   squawk;
	unsigned int sweeps;
	double azimuth[2];
	double distance[2];
	double speed[2];
} plane_info_t;

plane_info_t planes[200];
int numplanes, scenario;
FILE *inp, *outp;

void init_recs(void)
{ int i;
	numplanes=0;
	for (i=0; i<200; i++)
	{ planes[i].sweeps=0; }
}

void swap_recs(int a, int b)
{
#define pa planes[a]
#define pb planes[b]
	int          temp_int;
	unsigned int temp_uint;
	double       temp_float;

	temp_int = pa.squawk; pa.squawk=pb.squawk; pb.squawk=temp_int;
	temp_uint=pa.sweeps; pa.sweeps=pb.sweeps; pb.sweeps=temp_uint;
	temp_float=pa.azimuth[1]; pa.azimuth[1]=pb.azimuth[1]; pb.azimuth[1]=temp_float;
	temp_float=pa.azimuth[0]; pa.azimuth[0]=pb.azimuth[0]; pb.azimuth[0]=temp_float;
	temp_float=pa.distance[1]; pa.distance[1]=pb.distance[1]; pb.distance[1]=temp_float;
	temp_float=pa.distance[0]; pa.distance[0]=pb.distance[0]; pb.distance[0]=temp_float;
	temp_float=pa.speed[1]; pa.speed[1]=pb.speed[1]; pb.speed[1]=temp_float;
	temp_float=pa.speed[0]; pa.speed[0]=pb.speed[0]; pb.speed[0]=temp_float;
}

void sort_recs(void)
{ int i,j;

	for (i=0; i<numplanes; i++)
	{ for (j=0; j<(numplanes-1); j++)
		{ if (planes[j].squawk > planes[j+1].squawk)
			{ swap_recs(j, j+1); }
		}
	}
}

void add_sweep_entry(int ts, double az, double dist, double sp)
{ int i,found;

	for (i=0, found=0; (i<numplanes) && (!found); )
	{ found = (ts == planes[i].squawk);
		i += (1-found);
	}
	planes[i].azimuth[1]=az;
	planes[i].distance[1]=dist;
	planes[i].speed[1]=sp;
	planes[i].sweeps |= SWEEP2;
	planes[i].squawk = ts;
	numplanes+= (i == numplanes);
}

void read_sweeps(void)
{ int i, n2, ts;
	double az, dist, sp;

	fscanf(inp, "%d\n", &numplanes);
	for (i=0; i<numplanes; i++)
	{ fscanf(inp, "%d %lf %lf %lf\n", &(planes[i].squawk), &(planes[i].azimuth[0]),
					 &(planes[i].distance[0]), &(planes[i].speed[0]));
		planes[i].sweeps=SWEEP1;
	}

	fscanf(inp, "%d\n", &n2);
	for (i=0; i<n2; i++)
	{ fscanf(inp, "%d %lf %lf %lf\n", &ts, &az, &dist, &sp);
		add_sweep_entry(ts, az, dist, sp);
	}
}

void check_exit_loss(int i)
{
	if ( (10.0-planes[i].distance[0]) <= ((planes[i].speed[0] * 1.1)/720) )
	{ fprintf(outp,"%5d -- domain exited\n", planes[i].squawk); }
	else
	{ fprintf(outp,"%5d -- domain loss\n", planes[i].squawk); }
}

void check_intr_aloft(int i)
{
if ( (10.0-planes[i].distance[1]) <= ((planes[i].speed[1] * 1.1)/720) )
	{ fprintf(outp,"%5d -- new intrusion\n", planes[i].squawk); }
	else
	{ fprintf(outp,"%5d -- new aloft\n", planes[i].squawk); }
}

double compute_distance(int i)
{ double x1, x2, y1, y2;

	x1=sin((planes[i].azimuth[0]/180.0)*M_PI) * planes[i].distance[0];
	x2=sin((planes[i].azimuth[1]/180.0)*M_PI) * planes[i].distance[1];
	y1=cos((planes[i].azimuth[0]/180.0)*M_PI) * planes[i].distance[0];
	y2=cos((planes[i].azimuth[1]/180.0)*M_PI) * planes[i].distance[1];

	return(sqrt( (x1-x2) * (x1-x2) + (y1-y2) * (y1-y2)));
}
            
void check_equipment(int i)
{ double actual_dist, measured_dist;

	actual_dist = compute_distance(i);
	/* because time is 5 seconds, divide by 720 as well as 2*/
	measured_dist = (planes[i].speed[0] + planes[i].speed[1]) / 1440.0;

	if ((actual_dist<(measured_dist*0.9)) || (actual_dist>(measured_dist*1.1)))
	{ fprintf(outp, "%5d -- equipment warning\n", planes[i].squawk); }
}

void process_sweep(void)
{ int i;

	for (i=0; i<numplanes; i++)
	{ switch (planes[i].sweeps)
		{ case (1) : { check_exit_loss(i);  break; }
			case (2) : { check_intr_aloft(i); break; }
			case (3) : { check_equipment(i);  break; }
			default  : { break; } /* should not happen */
		}
	}
}

void main(void)
{ int scenario=0;
	inp  = fopen("radar.in",  "r");
	outp = fopen("radar.out", "w");

	while(!feof(inp))
	{ fprintf(outp, "Scenario # %1d\n", (++scenario));
		init_recs();
		read_sweeps();
		sort_recs();
		process_sweep();
		fprintf(outp, "\n");
	}
	fclose(inp);
	fclose(outp);
}
