#include <stdio.h>
#include <math.h>

typedef struct gear_t
{ int x,y,ir,or,visited;
	double r;
} gear_t;

gear_t gears[21];
FILE   *inp, *outp;
int    num_gears,overlap,conflict,sim_num;

long ir_gap(gear_t* g1, gear_t* g2)
{
	long dx = (g1->x - g2->x);
	long dy = (g1->y - g2->y);
	long dr = (g1->ir + g2->ir);
	return (dx*dx + dy*dy) - (dr*dr);
}

long or_gap(gear_t* g1, gear_t* g2)
{
	long dx = (g1->x - g2->x);
	long dy = (g1->y - g2->y);
	long dr = (g1->or + g2->or);
	return (dx*dx + dy*dy) - (dr*dr);
}

void read_sim(void)
{ int i;
	overlap=0; conflict=0;
	fscanf(inp, "%d %d %d %d %lf %d\n", &(gears[0].x), &(gears[0].y),
							&(gears[0].ir), &(gears[0].or), &(gears[0].r), &num_gears);
	for (i=1; i<=num_gears; i++)
	{ fscanf(inp, "%d %d %d %d\n",
							&(gears[i].x), &(gears[i].y), &(gears[i].ir), &(gears[i].or));
		gears[i].r=0.0;
		gears[i].visited=0;
	}
}

void compute_sim(int source)
{ int dest;
	double temp;

	for (dest=1; dest<=num_gears; dest++)
	{ if (ir_gap(gears+source, gears+dest) == 0)
		{ temp=-gears[source].r * ( ((double) gears[source].ir) / ((double) gears[dest].ir));
			if ((gears[dest].r != 0.0) && (gears[dest].r != temp))
			{ conflict=1; }
			else
			{ gears[dest].r=temp;
				if (!gears[dest].visited)
				{ gears[dest].visited=1;
					compute_sim(dest);
					gears[dest].visited=0;
				}
			}
		}
		if (or_gap(gears+source, gears+dest) == 0)
		{	temp=-gears[source].r * ( ((double) gears[source].or) / ((double) gears[dest].or));
			if ((gears[dest].r != 0.0) && (gears[dest].r != temp))
			{ conflict=1; }
			else if (gears[dest].r != temp)
			{ gears[dest].r=temp;
				if (!gears[dest].visited)
				{ gears[dest].visited=1;
					compute_sim(dest);
					gears[dest].visited=0;
				}
			}
		}
	}
}

void check_overlaps(void)
{ int a, b;
	for (a=0; a<num_gears; a++)
	{ for (b=a+1; b<=num_gears; b++)
		{ if ( (ir_gap(gears+a, gears+b) < 0) ||
					 (or_gap(gears+a, gears+b) < 0) )
			{ overlap=1; }
		}
	}
}

void print_sim(void)
{ int i;

	fprintf(outp, "Simulation #%1d\n", sim_num);
	if (overlap)
	{ fprintf(outp, "Error -- Overlapping Gears\n"); }
	else if (conflict)
	{ fprintf(outp, "Error -- Conflicting Gear Rotation \n"); }
	else
	{	for (i=1; i<=num_gears; i++)
		{ fprintf(outp, "%2d: ",i);
			if (gears[i].r == 0.0)
			{ fprintf(outp, "Warning -- Idle Gear\n",i); }
			else
			{ if (gears[i].r < 0.0)
				{ fprintf(outp, "L %1.2lf\n", (-gears[i].r)); }
				else
				{ fprintf(outp, "R %1.2lf\n", gears[i].r); }
			}
		}
	}
	fprintf(outp, "\n");
}

void main(void)
{ int  i, j;

	inp=fopen("gears.in","r");
	outp=fopen("gears.out","w");

  sim_num=0;
	while (!feof(inp))
	{ sim_num++;
		read_sim();
		check_overlaps();
		if (!overlap)
		{ compute_sim(0); }
		print_sim();
	}
	fclose(inp);
	fclose(outp);
}