program xeno (input, output);

#include "str.h"

const
  MAX_STRING = 1000;
  MAX_SPACER = MAX_STRING + 1;
  MAX_WORDS = MAX_STRING + 2 * 26;

type
  long_string = record
      length: integer;
      body: packed array[1..MAX_STRING] of char;
    end;
  count_array = array['a'..'z'] of integer;
  position_type = record
      start, finish: integer;
      first, repeated, overlaps, both: boolean;
    end;

var
  message: long_string;
  line: string;
  loop: integer;
  end_line: boolean;
  words_count: integer;
  words: array[1..MAX_WORDS] of position_type;


procedure mark_both;

  var
    loop, ptr: integer;
    ch, letter: char;
    counts: packed array[1..MAX_WORDS, 'a'..'z'] of integer;
    same: boolean;

  begin
  for loop := 1 to words_count do
    with words[loop] do
      if repeated then
        begin
        for ch := 'a' to 'z' do
          counts[loop, ch] := 0;
        with message do
          for ptr := start to finish do
            counts[loop, body[ptr]] := counts[loop, body[ptr]] + 1;
        end;

  for loop := 1 to words_count - 1 do
    with words[loop] do
      if first and repeated then
        if overlaps then
          both := TRUE
        else
          for ptr := loop + 1 to words_count do
            if words[ptr].repeated and (finish - start = words[ptr].finish - words[ptr].start) then
              begin
              same := TRUE;
              ch := 'a';
              while same and (ch <= 'z') do
                begin
                same := counts[loop, ch] = counts[ptr, ch];
                ch := succ(ch);
                end;
              if same and words[ptr].overlaps then
                both := TRUE;
              end;
  end;


procedure mark_repeated;

  var
    loop, ptr: integer;
    ch, letter: char;
    counts: packed array[1..MAX_WORDS, 'a'..'z'] of integer;
    same: boolean;

  begin
  for loop := 1 to words_count do
    with words[loop] do
      begin
      for ch := 'a' to 'z' do
        counts[loop, ch] := 0;
      with message do
        for ptr := start to finish do
          counts[loop, body[ptr]] := counts[loop, body[ptr]] + 1;
      end;

  for loop := 1 to words_count - 1 do
    with words[loop] do
      if not repeated then
        for ptr := loop + 1 to words_count do
          if (finish - start = words[ptr].finish - words[ptr].start) then
            begin
            same := TRUE;
            ch := 'a';
            while same and (ch <= 'z') do
              begin
              same := counts[loop, ch] = counts[ptr, ch];
              ch := succ(ch);
              end;
            if same then
              begin
              repeated := TRUE;
              words[ptr].repeated := TRUE;
              words[ptr].first := FALSE;
              end;
            end;
  end;


procedure mark_overlap;

  var
    loop, ptr: integer;

  begin
  for loop := 1 to words_count - 1 do
    with words[loop] do
      if repeated then
        for ptr := loop + 1 to words_count do
          if words[ptr].repeated and (words[ptr].start <= finish) then
            begin
            overlaps := TRUE;
            words[ptr].overlaps := TRUE;
            end;
  end;


procedure add_word (a_start, a_finish: integer);
VAR temp: integer;

  begin
  temp := a_finish - a_start + 1;
  if (temp > 1) AND (temp < 251) then
{--  if (a_finish - a_start + 1 in [2..250]) then--}
    begin
    words_count := words_count + 1;
    with words[words_count] do
      begin
      start := a_start;
      finish := a_finish;
      first := TRUE;
      repeated := FALSE;
      overlaps := FALSE;
      both := FALSE;
      end;
    end;
  end;


procedure scan_message;

  var
    loop: char;
    finish: integer;
    start: array['a'..'z'] of integer;

  begin
  for loop := 'a' to 'z' do
    start[loop] := 0;
  with message do
    for finish := 1 to length do
      begin
      add_word(start[body[finish]] + 1, finish - 1);
      start[body[finish]] := finish;
      end;
  for loop := 'a' to 'z' do
    if (start[loop] <> 0) then
      add_word(start[loop] + 1, message.length);
  end;


procedure solution;

  var
    loop, ptr: integer;

  begin
  for loop := 1 to words_count do
    with words[loop] do
      if first and both then
        begin
        for ptr := start to finish do
          write(message.body[ptr]);
        writeln;
        end;
  end;


begin

message.length := 0;
words_count := 0;
readln(line);
while (line <> '#') do
  begin
  if (length(line) > 0) then
    end_line := (line[length(line)] <> '-')
  else
    end_line := TRUE;
  for loop := length(line) downto 1 do
    if not (line[loop] in ['a'..'z']) then
      delete(line, loop, 1);
  if (length(line) > 0) then
    for loop := 1 to length(line) do
      begin
      message.length := message.length + 1;
      message.body[message.length] := line[loop];
      end;

  if end_line then
    begin
    for loop := message.length + 1 to MAX_STRING do
      message.body[loop] := ' ';

    scan_message;
    mark_repeated;
    mark_overlap;
    mark_both;
    solution;

    message.length := 0;
    words_count := 0;
    writeln('*');
    end;
  readln(line);
  end;
end.

