program Calculator(input, output);

#include "str.h"

type
	ItemTypes = (tNumber, tThing);
	StackPtr = ^StackItem;
	StackItem = record
			fNext: StackPtr;
			case fItemType : ItemTypes of
				tNumber: (
						fValue: Integer;
				);
				tThing: (
						fThing: Char;
				);
		end;

var
	line: string;
	stackCount: Integer;
	stackHead: StackPtr;
	start,variables: array['A'..'Z'] of Integer;


procedure Tell (comment: string;
								token: StackItem);

	begin
	write(comment);
	if token.fItemType = tNumber then
		write(token.fValue : 1)
	else
		write(token.fThing);
	if (comment <> '') then
		writeln;
	end;


procedure DumpStack;

	var
		ptr: StackPtr;

	begin
	write('Stack: ');
	ptr := stackHead;
	while (ptr <> nil) do
		begin
		Tell('', ptr^);
		write(' ');
		ptr := ptr^.fNext;
		end;
	writeln;
	end;


procedure Error (message: string);

	begin
	writeln('Be warned, message indicative of problem, but probably wrong message!!');
	writeln('JRG ', message, ' JRG');
	DumpStack;
	halt;
	end;


procedure Eat;

	var
		nuke: StackPtr;

	begin
	if (stackHead = nil) or (stackCount <= 0) then
		Error('Eat sanity check failed');
	nuke := stackHead;
	stackHead := stackHead^.fNext;
	Dispose(nuke);
	stackCount := stackCount - 1;
	end;


procedure AddToken (token: StackItem);

	var
		operand: Integer;
		keepGoing, lookingForRight: Boolean;
		temp: StackPtr;
		flag : boolean;

	begin
	lookingForRight := FALSE;
	if (token.fItemType = tThing) and (token.fThing = '(') then
		begin
		lookingForRight := TRUE;
		if (stackCount = 0) then
			Error('Mismatched bracket');
		token := stackHead^;
		Eat;
		end;
	keepGoing := TRUE;
	repeat
		flag :=  (token.fItemType = tNumber) and (stackCount >= 2);
		if flag then
			flag := (stackHead^.fItemType = tThing) and
				(stackHead^.fItemType = tThing) and
				(stackHead^.fNext^.fItemType = tNumber);
		if flag then
			begin
			operand := stackHead^.fNext^.fValue;
			case stackHead^.fThing of
			'+':
				token.fValue := token.fValue + operand;
			'*':
				token.fValue := token.fValue * operand;
			'-':
				token.fValue := token.fValue - operand;
			'/':
				token.fValue := token.fValue div operand;
			otherwise
				Error('Expression failed in "number operator number" situation');
			end;
			Eat;	{ operator }
			Eat;	{ number }
			end
		else if (token.fItemType = tThing) and (token.fThing in ['A'..'Z']) then
			begin
			if (stackCount = 0) or (stackHead^.fItemType <> tThing) or
       (stackHead^.fThing <> '=') then
				begin	{ Take value of variable }
				operand := variables[token.fThing];
				token.fItemType := tNumber;
				token.fValue := operand;
				end
			else
				begin	{ Perform assignment }
				if (stackCount < 2) then
					Error('Invalid stack size for assign')
				else if (stackHead^.fNext^.fItemType <> tNumber) then
					Error('Invalid assignment, must be number')
				else
					begin
					operand := stackHead^.fNext^.fValue;
					with token do
						begin
						variables[fThing] := operand;

						token.fItemType := tNumber;
						token.fValue := operand;
						end;
					Eat;	{ = }
					Eat;	{ number }
					end;
				end;
			end
		else
		    begin
		    flag := lookingForRight and (token.fItemType = tNumber) and
			    (stackCount >= 1);
		    if flag then 
			flag := (stackHead^.fItemType = tThing) and
				(stackHead^.fThing = ')');
		    if flag then
			begin
			Eat;	{ ) }
			lookingForRight := FALSE;
			end
		    else
			keepGoing := FALSE;
		end
	until not keepGoing;

	if lookingForRight then
		Error('Mismatched brackets');

	stackCount := stackCount + 1;
	New(temp);
	temp^ := token;
	temp^.fNext := StackHead;
	StackHead := temp;
	end;


procedure ProcessLine (line: string);

	var
		token: StackItem;
		first: Boolean;
		loop: Char;
		mark: Integer;

	begin
	for loop := 'A' to 'Z' do
		start[loop] := variables[loop];
	if (Pos('_ ', line) <> 0) then
		error('You said there would not be a space after an underscore!');
	while (Pos(' ', line) <> 0) do
		Delete(line, Pos(' ', line), 1);
	mark := 1;
	while (mark <= Length(line)) and (line[mark] in ['A'..'Z', '(', ')']) do
		mark := mark + 1;
	if (mark > Length(line)) or (line[mark] <> '=') then
		Error('First operator not =');

	while (Length(line) <> 0) do
		begin
		with token do
			if (line[Length(line)] in ['0'..'9']) then
				begin
				fItemType := tNumber;
				fValue := 0;
				mark := Length(line);
				while (mark > 0) and (line[mark] in ['0'..'9']) do
					mark := mark - 1;
				mark := mark + 1;
				while (mark <= Length(line)) do
					begin
					fValue := fValue * 10 + Ord(line[mark]) - Ord('0');
					Delete(line, mark, 1);
					end;
				if (line <> '') and (line[Length(line)] = '_') then
					begin
					fValue := -fValue;
					Delete(line, Length(line), 1);
					end;
				end
			else
				begin
				fItemType := tThing;
				fThing := line[Length(line)];
				Delete(line, Length(line), 1);
				end;
		AddToken(token);
		end;

	if (stackCount <> 1) or (stackHead^.fItemType <> tNumber) then
		Error('Expression did not parse??');

	first := TRUE;
	for loop := 'A' to 'Z' do
		if start[loop]<>variables[loop] then
			begin
			if first then
				first := FALSE
			else
				write(', ');
			write(loop, ' = ', variables[loop] : 1);
			end;
  if first then
     write('No Change');
	writeln;

	Dispose(stackHead);
	stackHead := nil;
	stackCount := 0;
	end;


procedure Init;

	var
		loop: Char;

	begin
	stackHead := nil;
	stackCount := 0;
	for loop := 'A' to 'Z' do
		variables[loop] := 0;
	end;

begin
Init;
readln(line);
while (line <> '#') do
	begin
	if (Length(line) > 100) then
		Error('Input line too long');
	ProcessLine(line);
	readln(line);
	end;

close(input);
end.