PROGRAM SomeProg;

#include "str.h"

VAR debugcounter: integer;

TYPE  vertextype = 'A'..'Z';
      visit_type = (null, pas, lisp);
      finishT = (bored, killed, both);

VAR   conn: array[vertextype, vertextype] of Boolean;
      visit: array[vertextype] of visit_type;
      herepas, herelisp: vertextype;
      finished: Boolean;
      newline: boolean;

PROCEDURE SolveProblem; forward;

PROCEDURE Done(p: visit_type; f: finishT; v: vertextype);
begin
if not newline then
  write(' ');
newline := false;
finished := true;
case p of
  null: write('Both');
  pas:  write('Paskill');
  lisp: write('Lisper');
  end;  (*case p*)

case f of
  bored:  write(' trapped ');
  killed: write(' destroyed ');
  both:   write(' annihilated ');
  end;  (*case f*)
write('in node ', V);
end;

FUNCTION Follow(c: vertextype): vertextype;
begin
  if c = 'Z'
    then Follow := 'A'
    else Follow := succ(c);
end;

FUNCTION Backup(c: vertextype): vertextype;
begin
  if c = 'A'
    then Backup:= 'Z'
    else Backup:= pred(c);
end;

FUNCTION ReadGraph: Boolean;
VAR s: string;
    i: integer;
    c1,c2: char;
    done: Boolean;

PROCEDURE Error(e:string);
begin
  writeln; writeln(s);
  if i > 2 then write(' ':i-2); writeln('^');
  writeln(e); HALT;
end;

FUNCTION GetChar: char; begin GetChar := s[i]; i := i + 1 end;
PROCEDURE CheckNode(c:char);
begin if not (c in ['A'..'Z']) then Error('Node name expected') end;

PROCEDURE ReadNodes;
begin
c1 := GetChar; CheckNode(c1);
c2 := GetChar; if c2 <> ':' then Error(': expected');
c2 := GetChar;
repeat
  CheckNode(c2); if c2 = c1 then Error('Self connected');
  conn[c1,c2] := true; conn[c2,c1] := true;
  c2 := Getchar;
  until c2 in [';', '.'];
done := c2 = '.';
end;  {Read Nodes}

begin  {Read Graph}
readln(s);
if s = '#' then
  ReadGraph := false
else
  begin
  ReadGraph := true; i := 1;
  for c1 := 'A' to 'Z' do begin
    for c2 := 'A' to 'Z' do conn[c1,c2] := false;
    visit[c1] := null end;

  repeat ReadNodes until done;

  repeat c1 := GetChar until c1 <> ' '; CheckNode(c1); herepas := c1;
  repeat c1 := GetChar until c1 <> ' '; CheckNode(c1); herelisp := c1;
  {**writeln('pas, lisp ', herepas, herelisp);{**}
  finished := false;
  end
end; {Read Graph}

PROCEDURE MovePas;
VAR next: vertextype;

begin
{**write('MovePas ', herepas, ' to ');{**}
visit[herepas] := pas; next := herepas;
repeat next := Follow(next)
  until (next = herepas) OR (conn[herepas,next] and (visit[next]=null));
if (next = herepas)
  then Done(pas, bored, herepas)
  else herepas := next;
{**write(herepas);{**}
end;

PROCEDURE MoveLisp;
VAR next: vertextype;

begin
{**write('    MoveLisp ', hereLisp, ' to ');{**}
visit[hereLisp] := lisp; next := hereLisp;
repeat next := Backup(next)
  until (next = hereLisp) OR (conn[hereLisp, next] and (visit[next] <> lisp));
if (next = hereLisp)
  then Done(lisp, bored, herelisp)
  else hereLisp := next;
if hereLisp = herePas then Done(null, both, hereLisp) else
if visit[next] = pas then Done(lisp, killed, hereLisp);
visit[hereLisp] := lisp; 
{**writeln(hereLisp);{**}
end;

PROCEDURE MainProg;
begin  {Main}

while ReadGraph do
  begin
  newline := true;
  SolveProblem;
  end
end; {of main procedure}

PROCEDURE SolveProblem;
begin
repeat MovePas; MoveLisp until finished; writeln;
end;

begin mainprog end.

