program Dragon;

type
	DirType = (left, right);
	GridPtr = ^GridArray;
	GridArray = array[1..8192] of record
			x, y: Integer;
		end;
	chararray = array[1..8192] of char;

var
	grid: GridPtr;	{ Mac hack! }
	fold: array[1..8192] of DirType;
	out: chararray;
	n: Integer;


procedure DoFold (lower, upper: Integer;
								hand: DirType);

	var
		mid: Integer;

	begin
	mid := (upper + lower) div 2;
	fold[mid] := hand;
	if upper > lower then
		begin
		DoFold(lower, mid - 1, left);
		DoFold(mid + 1, upper, right);
		end;
	end;


procedure writearr(out : chararray; len : integer);
var
   nonblank, i : integer;
begin
nonblank := len;
while out[nonblank] = ' ' do
   nonblank := nonblank - 1;
for i := 1 to nonblank do
   write(out[i]);
writeln;
end;


procedure DoIt;

	var
		i, num, minX, minY, maxX, maxY, line: Integer;
		sense: Integer;
		xInc, yInc: array[0..3, left..right] of Integer;

	begin
{ mac and PC compatible grotsville declaration}
	xInc[0, left] := 1;
	xInc[0, right] := 1;
	xInc[1, left] := -1;
	xInc[1, right] := 1;
	xInc[2, left] := -1;
	xInc[2, right] := -1;
	xInc[3, left] := 1;
	xInc[3, right] := -1;

	yInc[0, left] := 0;
	yInc[0, right] := -1;
	yInc[1, left] := 1;
	yInc[1, right] := 1;
	yInc[2, left] := -1;
	yInc[2, right] := 0;
	yInc[3, left] := 0;
	yInc[3, right] := 0;

	num := 1;
	for i := 1 to n do
		num := num * 2;

	DoFold(1, num - 1, left);

	minX := 0;
	minY := 0;
	maxX := 0;
	maxY := 0;
	grid^[1].x := 0;
	grid^[1].y := 0;
	sense := 0;
	for i := 2 to num do
		begin
		grid^[i].x := grid^[i - 1].x + xInc[sense, fold[i - 1]];
		grid^[i].y := grid^[i - 1].y + yInc[sense, fold[i - 1]];
		if (fold[i - 1] = left) then
			sense := (sense + 1) mod 4
		else
			sense := (sense + 3) mod 4;

		if (grid^[i].x > maxX) then
			maxX := grid^[i].x;
		if (grid^[i].x < minX) then
			minX := grid^[i].x;

		if (grid^[i].y > maxY) then
			maxY := grid^[i].y;
		if (grid^[i].y < minY) then
			minY := grid^[i].y;
		end;

	for line := maxY downto minY do
		begin
		for i := 1 to maxX - minX + 1 do
			out[i] := ' ';
		for i := 1 to num do
			if (grid^[i].y = line) then
				if odd(i) then
					out[grid^[i].x - minX + 1] := '_'
				else
					out[grid^[i].x - minX + 1] := '|';
		writearr(out, maxX - minX + 1);
		end;
	writeln('^');
	end;


begin
new(grid);

repeat
	readln(n);
	if (n > 0) then
		DoIt;
until (n = 0);
end.
