program A;

const
 kMax = 80;
 k2Max = 2 * kMax;

type
 PPCode = array[1..kMax] of Integer;
 MapSet = set of 1..kMax;
 MapType = packed array[1..k2Max] of MapSet;

var infile:text;

procedure Add (letter: Char;
       var word: string);

 var
  position: Integer;

 begin
 position := 1;
 while (letter > word[position]) do
  position := position + 1;
 Insert(letter, word, position);
 end;


function Test (k: Integer;
       plain, cypher: string;
       var code: PPCode): Boolean;

 var
  solved: Boolean;
  letter: Char;
  map: MapType;
  iterate, loop, where, target: Integer;

 begin
{ find possible mapping locations for all characters }
 for loop := 1 to Length(plain) do
  begin
  map[loop] := [];
  for where := 1 to k do
   begin
   target := where + k * ((loop - 1) div k);
   if (target > Length(cypher)) or (cypher[target] = plain[loop]) then
    map[loop] := map[loop] + [where];
   end;
  end;

{ compact multiple sets }
 solved := True;
 for iterate := 2 to (Length(plain) - 1) div k + 1 do
  for loop := 1 to k do
   begin
   target := loop + (iterate - 1) * k;
   if (target <= Length(plain)) then
    map[loop] := map[loop] * map[target];
   if (map[loop] = []) then
    solved := False;
   end;

 if solved then
  for loop := 1 to k do
   begin
   code[loop] := 0;
   for where := 1 to k do
    if (where in map[loop]) then
     begin
     if (code[loop] = 0) then
      code[loop] := where
     else
      write('*ambiguous solution*');
     end;
   end;

 Test := solved;
 end;


procedure Decode (message: string;
       k: Integer;
       code: PPCode);

 var
  iterate, loop: Integer;

 begin
 while (Length(message) mod k <> 0) do
  message := Concat(message, '?');

 for iterate := 1 to Length(message) div k do
  for loop := 1 to k do
   write(message[(iterate - 1) * k + code[loop]]);
 writeln;
 end;


procedure DoIt;

 var
  plain, cypher, message: string;
  fromPlain, fromCypher: string;
  k: Integer;
  solved: Boolean;
  code: PPCode;

 begin
 Readln(infile, plain);
 while (plain <> '#') do
  begin
  Readln(infile, cypher);
  Readln(infile, message);

  fromPlain := Chr(255);
  fromCypher := Chr(255);
  k := 0;
  solved := False;
  repeat
   k := k + 1;
   add(plain[k], fromPlain);
   add(cypher[k], fromCypher);
   if (fromPlain = fromCypher) then
    solved := Test(k, plain, cypher, code);

  until solved or (k = Length(plain));

  if solved then
   Decode(message, k, code)
  else
   writeln(message);
  Readln(infile, plain);
  end;
 end;


begin
Assign(infile, 'PROBLEMA.DAT'); reset(infile);

DoIt;
end.
